
Transcript print: 'Modifying stock Gtk'; cr!

Namespace current: GTK!

"GdkWindowObject superclass: GdkWindow!"

"Convenience"

GObject methodsFor: 'convenience'!

on: aSignalName send: aSelector to: aReceiver
    self 
	connectSignal: aSignalName 
	to: aReceiver 
	selector: aSelector 
	userData: nil
!

on: aSignalName send: aSelector to: aReceiver with: aData
    self 
	connectSignal: aSignalName 
	to: aReceiver 
	selector: aSelector 
	userData: aData
!
!

GtkTextBuffer methodsFor: 'convenience'!

getText
    | start end res |
    "Gets all text."
    start := GtkTextIter type new.
    end := GtkTextIter type new.
    self getBounds: start end: end.
    "Looking at the gtk-demo, it doesn't look like the result
     needs to be freed, although that seems odd"
    res := self getText: start end: end includeHiddenChars: false. 
    ^res
!

selectLine: aLine
    | iter |
    iter := GtkTextIter type new.
    self getIterAtLine: iter lineNumber: aLine.
    self placeCursor: iter.
    iter forwardToLineEnd.
    self moveMarkByName: 'selection_bound' where: iter.
!
!

GtkTreeModel class methodsFor: 'convenience'!

arrayOfTypesNamed: aTypeNames
    "To be used by Gtk(List|Tree)Store >> newTypeNames:.
     eg. GtkTreeStore newTypeNames: #('gint' 'gchararray' 'gchararray')
     aTypeNames must be a SequencableCollection."
    | arr |

    arr := (CArrayCType elementType: CIntType numberOfElements: aTypeNames size) new.
    aTypeNames keysAndValuesDo: [ :i :name |
	arr at: i - 1 put: (GValue typeFromName: name)
    ].

    ^arr
!
!

GtkListStore class methodsFor: 'convenience'!

newTypeNames: aTypeNames
    | arr |
    arr := GtkTreeModel arrayOfTypesNamed: aTypeNames.
    ^self newv: arr size types: arr.
!
!

GtkTreeStore class methodsFor: 'convenience'!

newTypeNames: aTypeNames
    | arr |
    arr := GtkTreeModel arrayOfTypesNamed: aTypeNames.
    "arr sizeof printNl.
    aTypeNames size printNl."
    ^self newv: aTypeNames size types: arr.
!
!

GtkWidget methodsFor: 'convenience'!

expand: aBoolean
    self getParent child: self propertiesAt: 'expand' put: aBoolean.
!
!

"Need to access the fields, so this needs to be declared properly"

"CStruct subclass: #GdkEventButton
        declaration: #( (#eventType #long)
                        (#window (#ptr #uLong))
                        (#send_event #char)
                        (#time #uLong)
                        (#x #double)
                        (#y #double)
                        (#axes (#ptr #double))
                        (#state #uInt)
                        (#button #uInt)
                        (#device (#ptr #uLong)) ""FIXME""
                        (#x_root #double)
                        (#y_root #double) )
        classVariableNames: ''
        poolDictionaries: ''
        category: ''
!
!"

Transcript print: 'Installing event dispatcher'; cr!

Gtk addClassVarName: 'activeDispatcher'
!

Gtk addClassVarName: 'activeDispatcherNo'
!

Gtk addClassVarName: 'activeDispatcherSemaphore'
!

Gtk addClassVarName: 'initialized'
!

Gtk class
	defineCFunc: 'gtk_events_pending'
	withSelectorArgs: 'eventsPending'
	returning: #int
	args: #( #void )!

Gtk class methodsFor: 'event dispatching'!

activeDispatcherSemaphore
    activeDispatcherSemaphore isNil ifTrue: [
	activeDispatcherSemaphore := Semaphore forMutualExclusion.
    ].
    ^activeDispatcherSemaphore
!

activeDispatcherIs: aProcess
    | rs |
    self activeDispatcherSemaphore critical:
	[ rs := (aProcess = activeDispatcher) ].
    ^rs.
!

dispatchEvents
    | process |
    process := Processor activeProcess.
    self activeDispatcherSemaphore critical:
	[ activeDispatcher := process ].
    [
	Processor yield.
	"Need to loop until Gtk eventsPending = 0, although
	      mainIterationDo should get rid of them too."
	"$. display."
	[ Gtk eventsPending > 0 ] whileTrue: 
	    [ Gtk mainIterationDo: false ].
	self activeDispatcherIs: process. 
    ] whileTrue.
!

newDispatcher
    | ps |
    ps := [ self dispatchEvents ] fork.
    "Numbering dispatcher processes for the purposes of debugging"
    activeDispatcherNo isNil 
	ifTrue: [ activeDispatcherNo := 1 ]
	ifFalse: [ activeDispatcherNo := activeDispatcherNo + 1 ].
    ps name: ('dispatcher no. ', activeDispatcherNo printString).
!

stopDispatcher
    "Dispatcher will finish when it returns"
    self activeDispatcherSemaphore critical:
	[ activeDispatcher := nil ].
!

listProcesses
    "Debugging"
    Process allInstancesDo: [ :each | 
	(((each == Processor activeProcess) ifTrue: [ '*' ] ifFalse: [ '' ]),
	     (each name ifNil: [ each ]))  printNl.
	].
    CallinProcess allInstancesDo: [ :each | 
	(((each == Processor activeProcess) ifTrue: [ '*' ] ifFalse: [ '' ]),
	     (each name ifNil: [ each ])) printNl.
	].
!

!

Gtk class methodsFor: 'images'!

destroyAllGtk
    GtkObject allSubclassesDo: [ :cls |
	cls allInstancesDo: [ :ins |
	    ins become: nil
	]
    ].
!

update: aParameter
    (aParameter == #returnFromSnapshot) ifTrue: [
	"self destroyAllGtk."
	initialized ifTrue: [ 
	    initialized := false. 
	    self initializeGtk 
	].
	self changed: #returnFromSnapshot.
	^self.
    ].
!

initializeGtk
    (initialized notNil and: [ initialized ]) ifTrue: [ ^self ].
    self bloxGtkInit.
    initialized := true.
!

finalizeGtk
    (initialized notNil and: [ initialized ]) ifFalse: [ ^self ].
    "FIXME self bloxGtkFinalize."
    initialized := false.
!
!

Namespace current: Smalltalk!

ObjectMemory addDependent: GTK.Gtk.
!
