!String methodsFor: 'string processing'! 

splitOnRegex: aPattern
    | curr last result |
    
    result := OrderedCollection new.
    last := 0 to: 0.
    [ last notNil ] whileTrue:
	[ | curr |
	    curr := self indexOfRegex: aPattern startingAt: last last.
	    curr notNil 
		ifTrue: [
		    result 
			add: (self copyFrom: last last + 1 to: curr first - 1);
		        add: (self copyFrom: curr first to: curr last).			    
		]
		ifFalse: [
		    result add: (self copyFrom: last last to: self size)
		].
	    last := curr.
	].
!
!

!SequenceableCollection methodsFor: 'enumerating'!

headDo: headBlock tailDo: tailBlock
    | n |
    n := self size.
    (n < 1) ifTrue: [ ^self ].
    headBlock value: self first.
    (n < 2) ifTrue: [ ^self ].
    self from: 2 to: n do: tailBlock.
!
!

!SequenceableCollection methodsFor: 'selecting'! 

odds
    | col |
    col := self copyEmpty.
    self doWithIndex: [ :each :i | i odd ifTrue: [ col add: each ] ].
    ^col
!

evens
    | col |
    col := self copyEmpty.
    self doWithIndex: [ :each :i | i even ifTrue: [ col add: each ] ].
    ^col
!
!

SequenceableCollection methodsFor: 'enumerating'!
joinStrings: aWithString
    "Assume that the elements of the receiver respond to #,
     return the results of using it to join them all together"

^self fold: [ :a :b | 
	a, aWithString, b
]   
! !
