"Filed out from GNU Smalltalk version 2.1.7 on 18-Feb-2004  8:53:54"!

LabelledTreeView subclass: #NamespaceView
	instanceVariableNames: 'treeMenuItems displayNamespace '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.NamespaceView comment: 
nil!

!GTK.Mumble.NamespaceView methodsFor: 'events'!

createSubclassOf: aClass named: aName
    | ns |
    "FIXME - Add to ChangeLog"
    ns := Namespace current.
    Namespace current: tm displayNamespace.
    aClass subclass: aName asSymbol
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: aClass category.
    Namespace current: ns.
!

fileOutClass: aClass to: aFileName
    | fs |
    fs := FileStream open: aFileName mode: FileStream write.
    
    aClass fileOutOn: fs.
    
    fs close.    
!

fileOutClassPrompt
    | cls pt fn fs |
    cls := tv selection.
    cls isNil ifTrue: [ 
	pt := Prompter 
	    title: 'No class is selected' 
	    entry: nil
	    buttons: (Prompter buttonsOk).
	[
	    (pt showModal: self).
	] fork.
	^self
    ].

    fn := 'changes/', (cls name ifNil: [ 'Unknown' ]), '.st'.

    pt := Prompter 
	title: ('Filing out ', cls name ifNil: [ 'Unknown' ]) 
	entry: 'File name: '
	buttons: (Prompter buttonsOkCancel).
    pt entryText: fn.
    (pt run = Gtk gtkResponseOk) ifTrue: [ 
        self fileOutClass: cls to: (self makeFileName: pt entryText)
    ]
!

makeFileName: aFileName
    "Strip out spaces, remove non-printing chars, etc."
    ^aFileName
!

subclassPrompt
    | cls pt |
    cls := tv selection.
    pt := Prompter 
	title: ('Create subclass of: ', cls name ifNil: [ 'Unknown' ]) 
	entry: 'Name: '
	buttons: (Prompter buttonsOkCancel).
    (pt run = Gtk gtkResponseOk) ifTrue: [ 
	self createSubclassOf: cls named: pt entryText
    ].
    pt destroy.
! !

!GTK.Mumble.NamespaceView methodsFor: 'initialization'!

buildMenuItems
    super buildMenuItems.
    menuItems
	section: 'Searching' add: 'Find class...' sending: #promptFindClass to: tm.
!

buildWidgets
    super buildWidgets.
    
    tv isNil ifTrue: [ tv := LookupTreeView new. ].
    tm := ClassTreeModel new.
    tm initializeTreeView: tv.
    tv sorted: true.

    self add: tv.

    lblBtn on: 'clicked' send: #rebuildModel to: tm.

    self hookupPopupMenuTo: tv treeView.
    displayNamespace notNil ifTrue: [ self redisplay ].
!

displayNamespace: aNamespace
    displayNamespace := aNamespace.
    self redisplay.
!

getPopupMenuItems: aMenuCollector forWidget: aWidget
    (aWidget = tv treeView) ifTrue: [
	aMenuCollector addAll: self treeMenuItems.
    ].
    ^aMenuCollector.!

redisplay
    super redisplay.
    self label: displayNamespace name.
    tm displayNamespace: displayNamespace.
!

treeMenuItems
    treeMenuItems isNil ifTrue: [
	treeMenuItems := MenuCollector new.
	treeMenuItems 
	    section: 'Filing' add: 'File out class...' sending: #fileOutClassPrompt to: self;
	    section: 'Editing' add: 'Subclass...' sending: #subclassPrompt to: self.
    ].
    ^treeMenuItems.! !


