"Filed out from GNU Smalltalk version 2.1.7 on 18-Feb-2004  8:53:02"!

Dialog subclass: #Prompter
	instanceVariableNames: ''
	classVariableNames: 'centreOnParent '
	poolDictionaries: ''
	category: 'Browser-Dialogs'!

GTK.Mumble.Prompter comment: 
nil!

!GTK.Mumble.Prompter class methodsFor: 'instance creation'!

buttonsOk
    ^Array with: Gtk gtkStockOk -> Gtk gtkResponseOk.!

buttonsOkCancel
    ^Array 
	with: Gtk gtkStockOk -> Gtk gtkResponseOk
	with: Gtk gtkStockCancel -> Gtk gtkResponseCancel.!

buttonsYesNo
    ^Array 
	with: Gtk gtkStockYes -> Gtk gtkResponseYes
	with: Gtk gtkStockNo -> Gtk gtkResponseNo.!

centreOnParent
    "This is naughty, but, although we would like the window manager to
     position transients on top of their parents, they sometimes put them
     in far away positions instead, which is rubbish.
     Other options would be to centre on the mouse or in the middle of the
     screen."
    ^centreOnParent ifNil: [ false ]!

centreOnParent: aBoolean
    centreOnParent := aBoolean
!

title: aTitle entry: aLabel buttons: aCollection
    | dlg |
    dlg := self new.
    dlg buildBasic.
    aTitle notNil ifTrue: [ dlg buildTitle: aTitle ].
    aLabel notNil ifTrue: [ dlg buildEntry: aLabel ].
    (dlg buildButtons: aCollection)
	ifFalse: [ dlg buildButtons: self buttonsOk ].
    ^dlg
! !

!GTK.Mumble.Prompter methodsFor: 'accessing'!

entryText
    ^entry getText
!

entryText: aText
    entry setText: aText
! !

!GTK.Mumble.Prompter methodsFor: 'initialization'!

buildBasic
    gtk := GtkDialog new.
    gtk	setTitle: 'Prompter'.
    gtk getVbox setSpacing: 9.
    gtk on: 'response' send: #response:arg1: to: self.
!

buildButtons: aCollection
    aCollection isNil ifTrue: [ ^false ].
    aCollection isEmpty ifTrue: [ ^false ].
    aCollection do: [ :assoc |
	gtk addButton: assoc key responseId: assoc value.
    ].
    ^true.!

buildEntry: aLabel
    | hbox vbox |
    vbox := gtk getVbox.
    vbox add: (hbox := (GtkHBox new: false spacing: 3) show; yourself).
    hbox add: ((GtkLabel new: aLabel) show; yourself).
    hbox add: (entry := (GtkEntry new) show; yourself).
    hbox expand: false.
!

buildTitle: aTitle
    | lbl |
    gtk getVbox add: (lbl := (GtkLabel new: aTitle) show; yourself).
    lbl expand: false.
! !


