Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #ProtocolTreeNode
	instanceVariableNames: 'type label children inherited parent '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

GTK.Mumble.ProtocolTreeNode comment: 
nil!

!GTK.Mumble.ProtocolTreeNode class methodsFor: 'instance creation'!

new: aType label: aLabel 
    ^(self new) 
	initialize; 
	type: aType; 
	label: aLabel; 
	yourself.! !

!GTK.Mumble.ProtocolTreeNode methodsFor: 'initialization'!

inherited
    ^inherited
!

inherited: aBoolean
    inherited := aBoolean
!

initialize
    "Using an OrderedCollection instead of a Set because CompiledMethod >> #=
       is broken"
    children := OrderedCollection new.
    inherited := false.
!

label
    ^label
!

label: aString
    label := aString
!

parent
    ^parent
!

parent: aParent
    parent := aParent
!

type
    ^type
!

type: aSymbol
    type := aSymbol
! !

!GTK.Mumble.ProtocolTreeNode methodsFor: 'tree'!

add: aObject
    (aObject isKindOf: ProtocolTreeNode) ifTrue: [
	aObject parent: self.
    ].
    children add: aObject
!

children 
    ^children
!

children: aCollection
    children := aCollection.
    children do: [ :each | each parent: self ].
!

isClassNode
    | n |
    n := self.
    [ n type = #meta ] 
	whileFalse: [
	    n parent isNil ifTrue: [ ^false "error, really" ].
	    n := n parent.
	].
    ^(n label startsWith: 'C')! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #UIModel
	instanceVariableNames: 'view '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GUI'!

GTK.Mumble.UIModel comment: 
nil!

!GTK.Mumble.UIModel methodsFor: 'accessing'!

view
^view
!

view: aView
view := aView
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

UIModel subclass: #LookupTreeModel
	instanceVariableNames: 'view '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Data Structures'!

GTK.Mumble.LookupTreeModel comment: 
nil!

!GTK.Mumble.LookupTreeModel methodsFor: 'accessing'!

getCols: aNode
    "Get column values for aNode"
    self subclassResponsibility.
!

getNodes: aNode
    "Get children of aNode or top level nodes if nil"
    self subclassResponsibility.
!

rebuildModel
    view ifNotNil: [ :vw | vw rebuildModel ].
    view defaultExpand.
! !

!GTK.Mumble.LookupTreeModel methodsFor: 'connecting to views'!

initializeTreeView: aTV
    "For convenience"
    aTV 
        initialize;
	nodesMsg: self -> #getNodes:;
	colsMsg: self -> #getCols:.
    "It's a shame to have to hold a reference, but it is hard to do without it
     for refreshing and searching (in particular)."
    view := aTV. 
    "and then, as appropriate;
     aTV buildColumns: #('Class')."
! !

!GTK.Mumble.LookupTreeModel methodsFor: 'searching'!

find: aValue in: aView
    "This probably isn't useful, but it gives the pattern"
    self subclassResponsibility
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LookupTreeModel subclass: #NamespaceTreeModel
	instanceVariableNames: 'displayNamespace '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

GTK.Mumble.NamespaceTreeModel comment: 
nil!

!GTK.Mumble.NamespaceTreeModel methodsFor: 'accessing'!

getCols: aClass
    ^Array with: (aClass name ifNil: [ '' ])!

getNodes: aNode
    aNode isNil ifTrue: [ ^Array with: Smalltalk ].
    aNode isNamespace ifTrue: [ ^aNode subspaces ].
    ^nil.! !

!GTK.Mumble.NamespaceTreeModel methodsFor: 'initialization'!

initializeTreeView: aTV
    super initializeTreeView: aTV.
    aTV buildColumns: #('Namespace').
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

UIModel subclass: #Browser
	instanceVariableNames: ''
	classVariableNames: 'wc runProcess'
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.Browser comment: 
nil!

!GTK.Mumble.Browser class methodsFor: 'callbacks'!

classSelectedCallback: aSender
    self createClassWindow: (aSender selection ifNil: [ ^self ]).
!

methodSelectedCallback: aSender
    | sel |
    sel := aSender selection.
    (sel isKindOf: CompiledMethod) ifFalse: [ ^self ].
    self createMethodWindow: sel.
!

namespaceSelectedCallback: aSender
    self createNamespaceWindow: (aSender selection ifNil: [ ^self ]). 
!

newMethodWindowFor: aClass
    self createMethodWindow: (aClass -> nil).
! !

!GTK.Mumble.Browser class methodsFor: 'environment'!

start
    "This method is intended to be called from the prompt / as a parameter 
      to create a new browser"
    Gtk initializeGtk.

    Browser createEvaluatorWindow.
    Browser createNamespacesWindow.
    Browser createNamespaceWindow: Smalltalk.

    "NotifierView handleErrors: true."

    Gtk newDispatcher.
    "If we allow this process to terminate, gst will quit."
    Processor activeProcess suspend.
!

stop
    runProcess ifNotNil: [ :rp | rp resume ].
!

stopDead
    runProcess ifNotNil: [ :rp | rp terminate ].
! !

!GTK.Mumble.Browser class methodsFor: 'window creation'!

createWindowWith: aView
    ^(WindowView new) 
	buildWidgets;
	add: aView;
	yourself.
!

createClassWindow: aClass
    | vw |
    vw := (ClassView new)
	buildWidgets;
	displayClass: aClass;
	onTreeSelectionSend: #methodSelectedCallback: to: self;
	show;
	yourself.

    (self createWindowWith: vw)
	defaultWidth: 400;
	defaultHeight: 500;
	show.
!

createEvaluatorWindow
    (EvaluatorView windowFor: nil) show.
!

createMethodWindow: aMethod
    | vw |
    vw := (MethodView new) 
	buildWidgets;
	displayMethod: aMethod;
	show;
	yourself.
    (self createWindowWith: vw)
        defaultWidth: 300;
	defaultHeight: 180;
	show.
!

createNamespacesWindow
    | vw |
    vw := (NamespacesView new)
	buildWidgets;
	onTreeSelectionSend: #namespaceSelectedCallback: to: self;
	show;
	yourself.
    (self createWindowWith: vw)
        defaultWidth: 300;
	defaultHeight: 180;
	show.
!

createNamespaceWindow: aNamespace
    | vw |
    vw := (NamespaceView new)
	buildWidgets;
	displayNamespace: aNamespace;
	onTreeSelectionSend: #classSelectedCallback: to: self;
	show;
	yourself.
    (self createWindowWith: vw)
	defaultWidth: 300;
	defaultHeight: 500;
	show.
!

createSmalltalkNamespaceWindow
    self createNamespaceWindow: Smalltalk
!

"createVariablesEditor: aClass
    (VariablesEditor new: 'VE', BrowserWindow nextWindowNumber printString)
	buildWindow;
	displayClass: aClass;
	show.
!"

imageDir
    ^(Smalltalk getenv: 'BROWSERDIR'), '/images'
! !

Smalltalk.Object subclass: #UIView
	instanceVariableNames: 'model parent children gtkValid'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GUI'!

GTK.Mumble.UIView comment: 
nil!

!GTK.Mumble.UIView methodsFor: 'accessing'!

model
^model
!

model: aModel
model := aModel
!

add: aView
    aView parent: self.
    self children add: aView.
    "...and add aView external to wherever appropriate"
! 

buildWidgets
    ^self 
!

rebuildWidgets
    self print.
    (gtkValid notNil and: [ gtkValid ]) ifTrue: [ 'nah' printNl. ^self ].
    'yeah' printNl.
    ^self buildWidgets
!

invalidateWidgets
    gtkValid := false.
!

show
    ^self
!

hide
    ^self
!

parent
    ^parent
!

redisplay
    ^self
!

children
    children isNil ifTrue: [ children := Set new ].
    ^children
!

external
    self subclassResponsibility.
!

!GTK.Mumble.UIView methodsFor: 'private'!

parent: aView
    parent := aView.
!
!

!GTK.Mumble.UIView class methodsFor: 'change and update'!

update: aParameter
    | n |
    "This should come from Gtk, not from ObjectMemory"
    (aParameter == #returnFromSnapshot) ifTrue: [ | todo resolved |
	todo := Set new.
	self withAllSubclassesDo: [ :cls | 
	    cls allInstancesDo: [ :each | 
		each invalidateWidgets.
		todo add: each.
	    ]
	].
	n := todo size.
	"Resolve dependencies"
	resolved := OrderedCollection new: todo size.
	[ | inst |
	    inst := todo anyOne.
	    [todo notEmpty] whileTrue: [
		(todo includes: inst parent) 
		    ifFalse: [
			resolved add: inst.
			todo remove: inst.
			inst := todo anyOne.
		    ]
		    ifTrue: [
			inst := inst parent.
		    ].
	    ]
	] value.
	resolved reverseDo: [ :each | each rebuildWidgets. ].
	"resolved do: [ :each | each redisplay. ]."
    ].
!
!

GTK.Gtk addDependent: GTK.Mumble.UIView.
!

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.UIView subclass: #MenuView
	instanceVariableNames: 'items'
	classVariableNames: 'categoryWeights'
	poolDictionaries: ''
	category: 'GUI'!

GTK.Mumble.MenuView comment: 
nil!

GTK.Mumble.MenuView class methodsFor: 'instance creation'!

new
    ^(self basicNew) initialize.
!
!

GTK.Mumble.MenuView methodsFor: 'initialization'!

initialize
    items := Dictionary new.
    ^self
!
!

GTK.Mumble.MenuView methodsFor: 'accessing'!

section: aSection add: aMenuItem
    | cat |
    cat := items at: aSection ifAbsentPut: [ OrderedCollection new ].
    cat add: aMenuItem.
!

addAll: aMenuView
    aMenuView isNil ifTrue: [ ^self ].
    aMenuView keysAndValuesDo: [ :k :v |
	v do: [ :each | 
	    self section: k add: each.
	].
    ].
!

categories
    ^items keys
!

categoryWeights
    categoryWeights isNil ifTrue: [
	categoryWeights := Dictionary new.
	categoryWeights 
	    at: 'Searching' put: 20;
	    at: 'Editing' put: 30;
	    at: 'Templates' put: 40;
	    at: 'Default' put: 50;
	    at: 'Filing' put: 85;
	    at: 'Closing' put: 90;
	    at: 'Quitting' put: 95.
    ].
    ^categoryWeights.
!

categoryWeight: aCategory
    ^self categoryWeights 
	at: aCategory
	ifAbsentPut: [ 
	    categoryWeights at: 'Default' ifAbsent: [ 50 ] 
	].
!

byCategory
    ^(items keys asSortedCollection: [ :a :b | 
	(self categoryWeight: a) <= (self categoryWeight: b)
    ]) collect: [ :each | items at: each ].
!

keysAndValuesDo: aBlock
    items isNil ifTrue: [ ^self ].
    items keysAndValuesDo: aBlock.
!
!

GTK.Mumble.MenuView methodsFor: 'convenience'!

newMenuItemLabel: aLabel sending: aSelector to: aReceiver
    "Convenience"
    ^(GtkMenuItem newWithLabel: aLabel)
	on: 'activate' send: aSelector to: aReceiver;
	show;
	yourself.
!

section: aSection add: aLabel sending: aSelector to: aReceiver
    "Convenience"
    self section: aSection add: (self newMenuItemLabel: aLabel sending: aSelector to: aReceiver).
!
!

GTK.Mumble.UIView subclass: #WindowedView
	instanceVariableNames: 'model parent children menuItems popupMenu'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GUI'!

GTK.Mumble.WindowedView comment: 
nil!

!GTK.Mumble.WindowedView methodsFor: 'events'!

hookupPopupMenuTo: aWidget
    aWidget isNil ifTrue: [ ^self ].
    aWidget on: 'button-press-event' send: #mouseButtonPressCallback:event: to: self .
!

mouseButtonPressCallback: aWidget event: aGdkEvent
    | btn pmnu |
    "Cast aGdkEvent from GdkEvent to GdkEventButton"
    aGdkEvent changeClassTo: GdkEventButton.
    btn := aGdkEvent button value.
    btn = 3 ifFalse: [ ^false ].
    "Cleanup the old menu if we can't reuse it"
    pmnu := nil.
    popupMenu notNil ifTrue: [
	(popupMenu key == aWidget) 
	    ifTrue: [ pmnu := popupMenu value. ]
	    ifFalse: [ popupMenu value destroy. ].
    ]. 
    pmnu isNil ifTrue: [ pmnu := self popupMenuFor: aWidget ].
    popupMenu := aWidget -> pmnu.
    "Pop it up"
    pmnu 
	popup: nil
	parentMenuItem: nil
        func: 0
        data: nil
	button: aGdkEvent button value
	activateTime: aGdkEvent time value.
    ^false.
! !

!GTK.Mumble.WindowedView methodsFor: 'popup menus'!

getPopupMenuItems: aMenuView
    menuItems isNil ifTrue: [ self buildMenuItems ].
    aMenuView addAll: menuItems.
    "parent notNil ifTrue: [ parent getPopupMenuItems: aMenuView ]."
    ^aMenuView.
!

getPopupMenuItems: aMenuView forWidget: aWidget
    ^aMenuView.
!

popupMenuFor: aWidget
    | items pmnu |
    "Build the menu"
    items := MenuView new.
    self getPopupMenuItems: items.
    self getPopupMenuItems: items forWidget: aWidget.

    pmnu := (GtkMenu new) show; yourself.
    items byCategory
	do: [ :cat |
	    cat do: [ :each | pmnu append: each ].
	]
	separatedBy: [ | it |
	    it := (GtkSeparatorMenuItem new) show; yourself.
	    pmnu append: it.
	].
    ^pmnu.
!

buildMenuItems
    menuItems := MenuView new.
    ^menuItems
!

!GTK.Mumble.WindowedView methodsFor: 'menu callbacks'!

fileInPrompt
    | dlg |
    dlg := FileSelection new: 'File in'.
    (dlg run = Gtk gtkResponseOk) 
	ifTrue: [ FileStream fileIn: dlg filename ].
    dlg destroy.
!

fileOutChangesCallback
	CurrentChanges 
		fileOutChangesTo: (self nextChangesFileEnding: '.st');
		clear.
!

fileOutChangesPromptCallback
    | pt nm |
    pt := Prompter 
	title: 'File out changes' 
	entry: 'File name:'
	buttons: (Prompter buttonsOkCancel).
    pt entryText: (self nextChangesFileEnding: '.st').

    (pt run = Gtk gtkResponseOk) ifTrue: [ | nm |
	CurrentChanges fileOutChangesTo: pt entryText.
    ].
    pt destroy.
!

fileOutClassesCallback
    | wd |
    wd := Directory working.
    Directory working: (Smalltalk getenv: 'BROWSERDIR').
    CurrentClasses fileOutTo: (self nextChangesFileEnding: '_cls.st').
    Directory working: wd.
!

nextChangesFileEnding: anEnd
    | dir fn |
    dir := (Directory name: 'changes').
    dir exists 
	ifFalse: [
	    "Broken"
	    Directory create: (Directory working, '/changes').
	    fn := 1.
	]
	ifTrue: [  
	    fn := 0.
	    dir filesMatching: ('*', anEnd) do: [ :each | | n nm |
		n := each stripPath asInteger.
		(n > fn) ifTrue: [ fn := n ].
	    ].
	    fn := fn + 1.
	].
    ^'changes/', fn printString, anEnd.!

snapshotCallback
    | fn |
    fn := self nextChangesFileEnding: '.im'.
    ObjectMemory snapshot: fn.
    Transcript 
	print: 'Snapshot saved to ', fn; 
	cr.
!

topLevelView
    ^self parent 
	ifNil: [ self ] 
	ifNotNil: [ :p | p topLevelView ].
!

windowView
    | wv |
    wv := self topLevelView.
    wv isWindow ifFalse: [ ^nil ].
    ^wv.
!

quitCallback
    | dlg rs |
    dlg := GtkMessageDialog 
	new: (self windowView ifNotNil: [ :w | w external ])
	flags: Gtk gtkDialogModal 
	type: Gtk gtkMessageQuestion
	buttons: Gtk gtkButtonsYesNo
	message: 'Really quit?'.
    rs := dlg run.
    dlg destroy.
    (rs = Gtk gtkResponseYes)
	ifTrue: [ WindowView closeAll. ]
! !

!GTK.Mumble.WindowedView methodsFor: 'testing'!

isWindow
    ^false
! !

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

WindowedView subclass: #Dialog
	instanceVariableNames: 'gtk vbox entry result runSemaphore parent '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Dialogs'!

GTK.Mumble.Dialog comment: 
nil!

!GTK.Mumble.Dialog methodsFor: 'accessing'!

parent: aParent
    parent := aParent
!

result
    ^result
! !

!GTK.Mumble.Dialog methodsFor: 'initialization'!

buildWidgets
    super buildWidgets.
    gtk := GtkDialog new.
    gtk on: 'response' send: #response:arg1: to: self.
! !

!GTK.Mumble.Dialog methodsFor: 'running'!

destroy
    gtk destroy
!

response: aSender arg1: aArg1 
    result := aArg1.
    runSemaphore signal.
!

run
    | process |
    "^gtk run"

    gtk isNil ifTrue: [ self buildWidgets ].

    process := Processor activeProcess.

    parent notNil ifTrue: [ gtk setTransientFor: parent ].
    gtk 
	setModal: true;
	show.

    runSemaphore := Semaphore new.

    "If we're about to suspend the event loop, we'll need another"
    (process name match: 'call-in process')
	ifTrue: [ Gtk newDispatcher ].

    result := nil.
    runSemaphore wait.

    gtk 
	setModal: false;
	hide.
    ^result
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Dialog subclass: #Prompter
	instanceVariableNames: ''
	classVariableNames: 'centreOnParent '
	poolDictionaries: ''
	category: 'Browser-Dialogs'!

GTK.Mumble.Prompter comment: 
nil!

!GTK.Mumble.Prompter class methodsFor: 'instance creation'!

buttonsOk
    ^Array with: Gtk gtkStockOk -> Gtk gtkResponseOk.!

buttonsOkCancel
    ^Array 
	with: Gtk gtkStockOk -> Gtk gtkResponseOk
	with: Gtk gtkStockCancel -> Gtk gtkResponseCancel.!

buttonsYesNo
    ^Array 
	with: Gtk gtkStockYes -> Gtk gtkResponseYes
	with: Gtk gtkStockNo -> Gtk gtkResponseNo.!

centreOnParent
    "This is naughty, but, although we would like the window manager to
     position transients on top of their parents, they sometimes put them
     in far away positions instead, which is rubbish.
     Other options would be to centre on the mouse or in the middle of the
     screen."
    ^centreOnParent ifNil: [ false ]!

centreOnParent: aBoolean
    centreOnParent := aBoolean
!

title: aTitle entry: aLabel buttons: aCollection
    | dlg |
    dlg := self new.
    dlg buildBasic.
    aTitle notNil ifTrue: [ dlg buildTitle: aTitle ].
    aLabel notNil ifTrue: [ dlg buildEntry: aLabel ].
    (dlg buildButtons: aCollection)
	ifFalse: [ dlg buildButtons: self buttonsOk ].
    ^dlg
! !

!GTK.Mumble.Prompter methodsFor: 'accessing'!

entryText
    ^entry getText
!

entryText: aText
    entry setText: aText
! !

!GTK.Mumble.Prompter methodsFor: 'initialization'!

buildBasic
    gtk := GtkDialog new.
    gtk	setTitle: 'Prompter'.
    gtk getVbox setSpacing: 9.
    gtk on: 'response' send: #response:arg1: to: self.
!

buildButtons: aCollection
    aCollection isNil ifTrue: [ ^false ].
    aCollection isEmpty ifTrue: [ ^false ].
    aCollection do: [ :assoc |
	gtk addButton: assoc key responseId: assoc value.
    ].
    ^true.!

buildEntry: aLabel
    | hbox vbox |
    vbox := gtk getVbox.
    vbox add: (hbox := (GtkHBox new: false spacing: 3) show; yourself).
    hbox add: ((GtkLabel new: aLabel) show; yourself).
    hbox add: (entry := (GtkEntry new) show; yourself).
    hbox expand: false.
!

buildTitle: aTitle
    | lbl |
    gtk getVbox add: (lbl := (GtkLabel new: aTitle) show; yourself).
    lbl expand: false.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LookupTreeModel subclass: #ClassTreeModel
	instanceVariableNames: 'displayNamespace listMode ancestors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Data Structures'!

GTK.Mumble.ClassTreeModel comment: 
nil!

!GTK.Mumble.ClassTreeModel methodsFor: 'accessing'!

ancestors
    | todo |
    ancestors isNil ifTrue: [
	todo := Array streamContents: [ :stream |
	    self displayNamespace allClassesDo: [ :each |
		stream nextPut: each
	    ]
	].
	ancestors := todo select: [ :each |
	    each superclass isNil or: [
		each superclass environment ~= displayNamespace
	    ]
	].
    ].
    ^ancestors.!

displayNamespace
    displayNamespace isNil ifTrue: [ displayNamespace := Smalltalk ].
    ^displayNamespace.!

displayNamespace: aNamespace
    displayNamespace := aNamespace.
    self rebuildModel.
!

getCols: aClass
    ^Array with: (aClass name ifNil: [ '' ])!

getNodes: aNode
    ^(self listMode 
	  ifTrue: [ self getNodesForList: aNode ]
	  ifFalse: [ self getNodesForTree: aNode ])!

getNodesForList: aNode
    | cls |
    aNode notNil ifTrue: [ ^nil ].
    cls := Array streamContents: [:stream | 
	self displayNamespace allClassesDo: [:each | 
	    stream nextPut: each
	]
    ].
    cls := cls asSortedCollection: 
	[ :a :b | 
	    [ (a name) <= (b name) ] on: Error do: 
		[ :sig | a print. ' ' print. b printNl. sig error: 'rethrown' ]
	].
    ^cls.!

getNodesForTree: aNode
    aNode isNil ifTrue: [ ^self ancestors ].
    aNode isClass ifTrue: [ 
	^aNode subclasses select: [ :each | 
	    each environment = displayNamespace
	]
    ].
    ^nil.!

listMode
    listMode isNil ifTrue: [ listMode := false ].
    ^listMode
! !

!GTK.Mumble.ClassTreeModel methodsFor: 'connecting to views'!

initializeTreeView: aTV
    super initializeTreeView: aTV.
    aTV buildColumns: #('Class').
! !

!GTK.Mumble.ClassTreeModel methodsFor: 'searching'!

find: aValue in: aView
    "This probably isn't useful, but it gives the pattern"
    aValue isString 
	ifTrue: [
	    ^aView find: [ :entry | entry name = aValue ]
	].
    aValue isClass
	ifTrue: [
	    ^aView find: [ :entry | entry = aValue ]
	].
    self error: 'Don''t know how to find ', aValue.
!

promptFindClass
    | pt |
    pt := Prompter 
	title: 'Find class' 
	entry: 'Class name:'
	buttons: (Prompter buttonsOkCancel).
    (pt run = Gtk gtkResponseOk) ifTrue: [ | nm |
    	    nm := pt entryText asSymbol.
	    (view find: [ :entry | entry name = nm ])
		ifNotNil: [ :it | view selectIter: it ]
    ].
    pt destroy.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Dialog subclass: #FileSelection
	instanceVariableNames: 'title '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Dialogs'!

GTK.Mumble.FileSelection comment: 
nil!

!GTK.Mumble.FileSelection class methodsFor: 'instance creation'!

new: aTitle
    ^(super new) title: aTitle; yourself
! !

!GTK.Mumble.FileSelection methodsFor: 'accessing'!

filename
    ^gtk getFilename.!

title: aTitle
    title := aTitle
! !

!GTK.Mumble.FileSelection methodsFor: 'initialization'!

buildWidgets
    "FIXME - We don't call super buildWidgets"
    gtk := GtkFileSelection new: title.
    gtk on: 'response' send: #response:arg1: to: self.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

WindowedView subclass: #WindowView
       instanceVariableNames: 'wnd ebox geom'
       classVariableNames: 'windows'
       poolDictionaries: ''
       category: 'Browser-Windows'!

GTK.Mumble.WindowView comment: 
nil!

!GTK.Mumble.WindowView class methodsFor: 'quitting'!

closeAll
    windows copy do: [ :each | each close: self ].
! !

!GTK.Mumble.WindowView methodsFor: 'initialization'!

buildMenuItems
    super buildMenuItems.
    menuItems
	section: 'Closing' add: 'Close window' sending: #close: to: self;
	section: 'Quitting' add: 'Quit...' sending: #quitCallback to: self.
    ^menuItems
!

buildWidgets    
    super buildWidgets.
    wnd := GtkWindow new: Gtk gtkWindowToplevel.
    wnd setTitle: 'Testing'.
    wnd add: ((ebox := GtkEventBox new) show; yourself).
    self hookupPopupMenuTo: ebox.

    windows isNil ifTrue: [ windows := Set new ].
    windows add: self.

    children notNil ifTrue: [ ebox add: children anyOne external ].
!

redisplay
    self 
	restoreGeometry;
	show.
!

!GTK.Mumble.WindowView methodsFor: 'accessing'!

external
    ^wnd
!

!GTK.Mumble.WindowView methodsFor: 'delegation'!

add: aView
    super add: aView.
    ebox add: aView external.
!

close
    self close: self
!

close: aSender
    windows remove: self ifAbsent: [ ('Internal error: BrowserWindow ', wnd title printString, ' was not in the window list.') printNl ].
    wnd destroy.
    windows isEmpty ifTrue: [ 
	Gtk stopDispatcher.
	Browser stopDead.
    ].
!

defaultHeight: aHeight
    wnd propertiesAt: 'default-height' put: aHeight
!

defaultWidth: aWidth
    wnd propertiesAt: 'default-width' put: aWidth
!

propertiesAt: aProp put: aValue
    wnd propertiesAt: aProp put: aValue.
!

show
    wnd show.
!

title: aTitle
    (gtkValid notNil and: [ gtkValid ]) ifFalse: [ ^self ].
    wnd setTitle: aTitle.
!
!

!GTK.Mumble.WindowView methodsFor: 'saving and loading'!

restoreGeometry
    "self position: geom."
!

saveGeometry
    "geom := self position."
! 
!

!GTK.Mumble.WindowView methodsFor: 'testing'!

isWindow
    ^true
!
!

WindowedView subclass: #BrowserView
	instanceVariableNames: 'vbox'
	classVariableNames: 'windows '
	poolDictionaries: ''
	category: 'Browser-Windows'!

GTK.Mumble.BrowserView comment: 
nil!

!GTK.Mumble.BrowserView methodsFor: 'accessing'!

external
    ^vbox
!
!

!GTK.Mumble.BrowserView methodsFor: 'initialization'!

buildMenuItems
    super buildMenuItems.
    menuItems
	section: 'Windows' add: 'Open Evaluator window...' sending: #createEvaluatorWindow to: Browser;
	section: 'Windows' add: 'Open Namespaces window...' sending: #createNamespacesWindow to: Browser;
	section: 'Windows' add: 'Open Namespace window for Smalltalk...' sending: #createSmalltalkNamespaceWindow to: Browser;
	section: 'Filing' add: 'File in file...' sending: #fileInPrompt to: self;
	section: 'Filing' add: 'File out changes...' sending: #fileOutChangesCallback to: self;
	section: 'Filing' add: 'File out changes to...' sending: #fileOutChangesPromptCallback to: self;
	section: 'Filing' add: 'File out classes...' sending: #fileOutClassesCallback to: self;
	section: 'Filing' add: 'Save snapshot...' sending: #snapshotCallback to: self.
    ^menuItems
!

buildWidgets
    super buildWidgets.
    (vbox := GtkVBox new: false spacing: 3) 
	show;
	setBorderWidth: 9.
    self hookupPopupMenuTo: vbox. "FIXME"
!
!

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

BrowserView subclass: #MethodView
	instanceVariableNames: 'cls sel labelBtn editBtn acceptBtn cancelBtn text tv ignoreEdit '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

GTK.Mumble.MethodView comment: 
nil!

!GTK.Mumble.MethodView methodsFor: 'events'!

acceptClick
    self compile ifTrue: [ self editMode: false. ].    
!

cancelClick
    self
	editMode: false;
	resetText.
!

editClick
    ignoreEdit ifNotNil: [ :a | a ifTrue: [ ^self ] ].
    self editMode: true
! !

!GTK.Mumble.MethodView methodsFor: 'initialization'!

buildWidgets
    | wnd btns fr scr lbl al i |

    super buildWidgets.
    
    btns := (GtkHBox new: false spacing: 3) show; yourself.

    labelBtn := (GtkButton newWithLabel: lbl) show; yourself.
    labelBtn setRelief: Gtk gtkReliefNone.

    al := (GtkAlignment new: 0.5 yalign: 0.5 xscale: 0.3 yscale: 1.0) show; yourself.
    btns add: al.
    al add: labelBtn.

    editBtn := (GtkButton new) show; yourself.
    editBtn add: ((GtkImage newFromFile:  (Browser imageDir), '/edit.png') show; yourself).

    btns add: editBtn.
    editBtn expand: false.
    editBtn on: 'clicked' send: #editClick to: self.

    acceptBtn := (GtkButton new) show; yourself.
    acceptBtn add: ((GtkImage newFromFile:  (Browser imageDir), '/accept.png') show; yourself).

    btns add: acceptBtn.
    acceptBtn expand: false.
    acceptBtn on: 'clicked' send: #acceptClick to: self.

    cancelBtn := (GtkButton new) show; yourself.
    cancelBtn add: ((GtkImage newFromFile:  (Browser imageDir), '/cancel.png') show; yourself).

    btns add: cancelBtn.
    cancelBtn expand: false.
    cancelBtn on: 'clicked' send: #cancelClick to: self.

    fr := (GtkFrame new: nil) show; yourself.
    fr add: (scr := (GtkScrolledWindow new: nil vadjustment: nil) show; yourself).
    i := Gtk gtkPolicyAutomatic.
	"scr class enum: 'GtkPolicyType' value: 'automatic'."
    scr setPolicy: i vscrollbarPolicy: i.
    "scr property: 'hscrollbar-policy' value: i.
    scr property: 'vscrollbar-policy' value: i."

    text := GtkTextBuffer new: nil.
    text on: 'insert-text' send: #editClick to: self.
    text on: 'delete-range' send: #editClick to: self.
    scr add: ((tv := GtkTextView newWithBuffer: text) show; yourself).

    vbox
	add: btns; 
	add: fr.
    btns expand: false.
    self
	editMode: false.
!

displayMethod: aMethodOrAssoc
    (aMethodOrAssoc isKindOf: Association) 
	ifTrue: [ 
	    cls := aMethodOrAssoc key.
	    sel := aMethodOrAssoc value.
	].
    (aMethodOrAssoc isKindOf: CompiledMethod) 
   	ifTrue: [ 
	    cls := aMethodOrAssoc methodClass.
	    sel := aMethodOrAssoc selector.
	].
    self
	resetLabel;
	resetText.
! !

!GTK.Mumble.MethodView methodsFor: 'modes'!

compile
    | cm cat newSel |
    cat := (sel notNil and: [cls includesSelector: sel])
	ifTrue: [ (cls compiledMethodAt: sel) methodCategory ]
	ifFalse: [ 'unknown' ].

    cm := cls
	compile: text getText
        classified: cat
        ifError: [ :fname :lineNo :errorString | 
	    (lineNo printString, ': ', errorString) printNl.
	    ^false.
	].

    "Retrieve selector"
    newSel := cls selectorAt: cm.
    sel := newSel.

    "Change Log entry"
    CurrentChanges methodChange: cls -> sel.
    "cls fileOutSelector: sel toStream: ChangeLog.
    ChangeLog flush."
    "ChangeLog nextPutAll: cls printString, '' compile: '', 
        text getText printString, '' classified: '', cat printString."

    ^true
!

editMode: aBoolean
    acceptBtn propertiesAt: 'visible' put: aBoolean.
    cancelBtn propertiesAt: 'visible' put: aBoolean.
    editBtn propertiesAt: 'visible' put: aBoolean not.
    "tv property: 'editable' value: aBoolean."
!

resetLabel
    | cn mn lbl |
    cn := cls name ifNil: [ cls printString ].
    mn := sel ifNotNil: [ :s | sel asString ] ifNil: [ 'new method' ].
    lbl := cn, ' >> ', mn.    
    self windowView ifNotNil: [ :w | w title: lbl ].
    labelBtn setLabel: lbl.
!

resetText
    ignoreEdit := true.
    text setText: (
	sel
	    ifNil: [ '"New method"' ]
	    ifNotNil: [ :s | cls sourceCodeAt: sel ]
    ) len: -1.
    ignoreEdit := false.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #EventNotification
	instanceVariableNames: 'receiver selector data '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Utility-Events'!

GTK.Mumble.EventNotification comment: 
nil!

!GTK.Mumble.EventNotification class methodsFor: 'instance creation'!

newSending: aSelector to: aReceiver with: aData
    ^(self new) send: aSelector to: aReceiver data: aData; yourself
! !

!GTK.Mumble.EventNotification methodsFor: 'activation'!

sendFrom: aSource
    self sendFrom: aSource with: nil
!

sendFrom: aSource with: aEventInfo
    | args | 
    selector numArgs = 0 
	ifTrue: [
	    receiver perform: selector.
        ]
	ifFalse: [
	    args := OrderedCollection with: aSource.
	    aEventInfo notNil ifTrue: [ args add: aEventInfo ].
	    data notNil ifTrue: [ args add: data ].
	    receiver perform: selector withArguments: (args asArray).
	].
! !

!GTK.Mumble.EventNotification methodsFor: 'initialization'!

send: aSelector to: aReceiver data: aData
    receiver := aReceiver.
    selector := aSelector.
    data := aData.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #EventSource
	instanceVariableNames: 'notifications source '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Utility-Events'!

GTK.Mumble.EventSource comment: 
nil!

!GTK.Mumble.EventSource class methodsFor: 'instance creation'!

new
    | es |
    es := self basicNew.
    es source: es.
    ^es.!

newFrom: aSource
    ^(self basicNew) source: aSource; yourself.! !

!GTK.Mumble.EventSource methodsFor: 'accessing'!

dontSendTo: aReceiver
    notifications isNil ifTrue: [ ^self ].
    notifications removeKey: aReceiver ifAbsent: [].
!

send: aSelector to: aReceiver
    self send: aSelector to: aReceiver with: nil.
!

send: aSelector to: aReceiver with: aData
    notifications isNil ifTrue: [ notifications := WeakKeyDictionary new ].
    notifications 
	at: aReceiver 
	put: (EventNotification newSending: aSelector to: aReceiver with: aData).
! !

!GTK.Mumble.EventSource methodsFor: 'private'!

source: aSource
    source := aSource
! !

!GTK.Mumble.EventSource methodsFor: 'triggering'!

send
    notifications isNil ifTrue: [ ^self ].
    notifications keysAndValuesDo: [ :key :val | val sendFrom: source ].
!

sendWith: aEventInfo
    notifications isNil ifTrue: [ ^self ].
    notifications keysAndValuesDo: [ :key :val | val sendFrom: source with: aEventInfo ].
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #NamedEventsSource
	instanceVariableNames: 'events '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Utility-Events'!

GTK.Mumble.NamedEventsSource comment: 
nil!

!GTK.Mumble.NamedEventsSource methodsFor: 'accessing'!

includes: aEvent
    ^events includesKey: aEvent.!

named: aName
    ^events at: aName
!

on: aEvent dontSendTo: aReceiver
    (self at: aEvent ifAbsent: [ ^self ])
	dontSendTo: aReceiver
!

on: aEvent send: aSelector to: aReceiver
    self on: aEvent send: aSelector to: aReceiver with: nil.
!

on: aEvent send: aSelector to: aReceiver with: aData
    (aReceiver respondsTo: aSelector) ifFalse: [
	self error: aReceiver printString, ' does not understand ', aSelector, ' - event ''', aEvent, ''' will not be connected.'
    ].
    (self named: aEvent) send: aSelector to: aReceiver with: aData
! !

!GTK.Mumble.NamedEventsSource methodsFor: 'initialization'!

add: aName
    events at: aName put: EventSource new.
!

add: aName from: aSource
    events at: aName put: (EventSource newFrom: aSource).
!

initialize
    events := Dictionary new.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

WindowedView subclass: #LookupTreeView
	instanceVariableNames: 'vbox tree treeView nodesMsg colsMsg changing events selection entries sorted '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

GTK.Mumble.LookupTreeView comment: 
nil!

!GTK.Mumble.LookupTreeView class methodsFor: 'instance creation'!

new: aName columns: aTitles
    "Convenience method for creating simple tree views"
    ^(self new: aName)
	initialize;
	buildColumns: aTitles.! !

!GTK.Mumble.LookupTreeView methodsFor: 'accessing'!

colsMsg: aAssoc
    colsMsg := aAssoc
!

nodesMsg: aAssoc
    nodesMsg := aAssoc
!

selection
    ^selection
!

sorted
    ^sorted
!

sorted: aValue
    "FIXME"
    sorted := aValue.
! !

!GTK.Mumble.LookupTreeView methodsFor: 'convenience'!

selectIter: anIter
    treeView expandToPath: (tree getPath: anIter).
    treeView getSelection selectIter: anIter.
    treeView scrollToCell: anIter column: nil useAlign: false xAlign: 0.0 yAlign: 0.0.
!

showIter: anIter
    treeView 
	expandToPath: (tree getPath: anIter);
	scrollToCell: anIter column: nil useAlign: false xAlign: 0.0 yAlign: 0.0.
! !

!GTK.Mumble.LookupTreeView methodsFor: 'events'!

on: aEvent send: aSelector to: aReceiver
    (events includes: aEvent) 
	ifTrue: [ events on: aEvent send: aSelector to: aReceiver ]
	ifFalse: [ super on: aEvent send: aSelector to: aReceiver ].
!

rowActivatedCallback: aSender
    (events named: 'activated') send.
!

selectionChangedCallback: aSender
    | it i |
    changing notNil ifTrue: [ ^self ].
    changing := treeView.

    treeView getSelection getMode = Gtk gtkSelectionSingle ifFalse: [ ^self ].

    it := GtkTreeIter type new.
    selection := (treeView getSelection getSelected: nil iter: it)
	ifTrue: [ entries at: (tree getOop: it column: 0). ]
	ifFalse: [ nil ].

    changing := nil.
    ^self
! !

!GTK.Mumble.LookupTreeView methodsFor: 'initialization'!

addTo: aParent
    aParent add: vbox.
!

buildColumns: aTitles
    "Convenience method for creating simple tree views"
    | col rend typs |
    "typs := (OrderedCollection with: (GValue typeFromName: 'gint'))
	addAll: (aTitles collect: [ :each | GValue typeFromName: 'gchararray' ]);
	yourself.
    tree := GtkTreeStore new: typs size varargs: typs asArray."

    typs := (CArrayCType elementType: CIntType numberOfElements: aTitles size + 1) new.
    typs at: 0 put: (GValue typeFromName: 'gint').
    1 to: aTitles size do: [ :i | 
        typs at: i put: (GValue typeFromName: 'gchararray').
    ].

    tree := GtkTreeStore newv: aTitles size + 1 types: typs.

    treeView setModel: tree.

    aTitles doWithIndex: [ :ttl :i |
	col := GtkTreeViewColumn new.
	treeView insertColumn: col position: -1. "-1 => append"
	col setTitle: ttl.
	col packStart: (rend := GtkCellRendererText new) expand: true.
	col addAttribute: rend attribute: 'text' column: i.
    ].
!

buildWidgets
    | frame scroll |  

    super buildWidgets.

    (vbox := GtkVBox new: false spacing: 3) show.
    (frame := GtkFrame new: nil) show.
    vbox add: frame.

    (scroll := GtkScrolledWindow new: nil vadjustment: nil) show.
    frame add: scroll.
    scroll setPolicy: Gtk gtkPolicyAutomatic vscrollbarPolicy: Gtk gtkPolicyAutomatic.

    (treeView := GtkTreeView new) show.
    scroll add: treeView.

    treeView propertiesAt: 'headers-visible' put: false.
    treeView getSelection on: 'changed' send: #selectionChangedCallback: to: self.
    treeView on: 'row-activated' send: #rowActivatedCallback: to: self.
!

colsFor: aEntry
    ^colsMsg key perform: colsMsg value with: aEntry
!

defaultExpand
    | it oc | 
    "Expand all root nodes"
    it := GtkTreeIter type new.
    oc := tree class.
    tree changeClassTo: GtkTreeModel.
    [
	tree iterChildren: it parent: nil.
	it isNil ifTrue: [ ^self ].
	[ 
	    treeView expandToPath: (tree getPath: it).
	    tree iterNext: it.
	] whileTrue.
    ] ensure: [
	tree changeClassTo: oc.
    ]
!

firstColFor: aEntry
     ^(self colsFor: aEntry) at: 1.!

external 
    ^vbox
!

initialize
    sorted := true.
    "listMode := false.
    inheritedMode := false."

    events := (NamedEventsSource new) initialize; yourself.
    events add: 'activated' from: self.

    self buildWidgets.
    "Now the subclass has to build the columns. Column 0 should always
     be gint - it will contain an id used to lookup the entry for the
     current selection."
!

nodesFor: aNode
    ^nodesMsg key perform: nodesMsg value with: aNode.!

redisplay
    self rebuildModel.
!

rebuildModel
    tree clear.
    (nodesMsg isNil | colsMsg isNil) ifTrue: [ ^self ].
    "Build the tree"
    entries := Dictionary new. "entries is the reverse lookup"
    self rebuildNode: nil atIter: nil.
    self defaultExpand. "display method - move out?"
!

rebuildNode: aNode atIter: aParent
    | nds cols it n |
    nds := self nodesFor: aNode.
    nds isNil ifTrue: [ ^self ].

    cols := OrderedCollection new: nds size.
    nds do: [ :nd | 
	cols add: nd -> (self colsFor: nd)
    ].

    sorted ifTrue: [ 
	"Sort by first column"
	cols := cols asSortedCollection: [ :a :b | 
	    (a value at: 1) <= (b value at: 1)
	].
    ].

    cols do: [ :each | 
	n := entries size + 1.
	it := GtkTreeIter type new.
	tree append: it parent: aParent.
	tree setOop: it column: 0 value: n.
	each value doWithIndex: [ :col :i |
	    tree setOop: it column: i value: col
	].
	entries at: n put: each key.
	self rebuildNode: each key atIter: it.
    ].
!

tree
    ^tree
!

tree: aTreeModel
    tree := aTreeModel.
    treeView setModel: tree.
!

treeView
    ^treeView
! !

!GTK.Mumble.LookupTreeView methodsFor: 'searching'!

find: aBlock 
    | i |
    "This isn't the most efficient process ever"
    i := self findId: aBlock.
    i isNil ifTrue: [ ^nil ].
    "If we found a value for i, then it ought to be in the tree"
    tree walkTree: [ :it |
	(it column: 0) = i ifTrue: [ ^it ]
    ].
    self error: 'It should be here somewhere...'.
!

findEntry: anEntry
    ^self find: [ :entry | entry = anEntry ]
!

findId: aBlock
    entries keysAndValuesDo: [ :id :entry |
	(aBlock value: entry) ifTrue: [ ^id ]
    ].
    ^nil
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #ChangeRecord
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Changes'!

GTK.Mumble.ChangeRecord comment: 
nil!

!GTK.Mumble.ChangeRecord methodsFor: 'filing'!

fileOutChangeOn: aStream
    self subclassResponsibility
! !

!GTK.Mumble.ChangeRecord methodsFor: 'testing'!

changeType
    self subclassResponsibilty.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

BrowserView subclass: #LabelledView
	instanceVariableNames: 'lblBtn ' "FIXME labelMsg"
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.LabelledView comment: 
nil!

!GTK.Mumble.LabelledView methodsFor: 'initialization'!

buildWidgets
    | al |
    super buildWidgets.
    vbox add: (al := self createCentredLabelButton).
    vbox child: al propertiesAt: 'expand' put: false.
!

createCentredLabelButton
    | al |
    (al := GtkAlignment new: 0.5 yalign: 0.5 xscale: 0.3 yscale: 1.0) show; yourself.
    al add: ((lblBtn := GtkButton newWithLabel: '') show; yourself).
    lblBtn propertiesAt: 'relief' put: Gtk gtkReliefNone.
    ^al
!

label: aLabel
    self windowView ifNotNil: [ :w | w title: aLabel ].
    lblBtn getChild setMarkup:
	'<span size="large">', aLabel, '</span>'.! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LabelledView subclass: #LabelledTreeView
	instanceVariableNames: 'tm tv selectionSend '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.LabelledTreeView comment: 
nil!

!GTK.Mumble.LabelledTreeView methodsFor: 'initialization'!

add: aView
    super add: aView.
    vbox add: aView external.
!

onTreeSelectionSend: aSelector to: aObject
    selectionSend := aObject -> aSelector.
    tv notNil ifTrue: [
	tv on: 'activated' send: aSelector to: aObject.
    ].
!

"buildWidgets
    super buildWidgets.
    self onTreeSelectionSend: selectionSend value to: selectionSend key.
!"
!

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LabelledTreeView subclass: #NamespacesView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.NamespacesView comment: 
nil!

!GTK.Mumble.NamespacesView methodsFor: 'initialization'!

buildWidgets
    | al btn |

    super buildWidgets.

    self label: 'Namespaces'.

    tv isNil ifTrue: [ tv := LookupTreeView new. ].
    tm := NamespaceTreeModel new.
    tm 
	initializeTreeView: tv;
	rebuildModel.
    tv sorted: true.

    self add: tv.
    lblBtn on: 'clicked' send: #rebuildModel to: tm.
!
!

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LookupTreeModel subclass: #StackTraceTreeModel
	instanceVariableNames: 'stacktrace '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Data Structures'!

GTK.Mumble.StackTraceTreeModel comment: 
nil!

!GTK.Mumble.StackTraceTreeModel methodsFor: 'accessing'!

getCols: aContext
    ^Array with: (aContext printString ifNil: [ '' ])!

getNodes: aNode
    ^aNode isNil ifTrue: [ stacktrace ] ifFalse: [ nil ]!

stacktrace: aCollection
    stacktrace := aCollection.
    self rebuildModel.
! !

!GTK.Mumble.StackTraceTreeModel methodsFor: 'connecting to views'!

initializeTreeView: aTV
    super initializeTreeView: aTV.
    aTV buildColumns: #('Stack').
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

BrowserView subclass: #NotifierView
	instanceVariableNames: 'tm tv errorMsg process errorLbl'
	classVariableNames: 'handleErrors '
	poolDictionaries: ''
	category: 'Graphics-Browser'!

GTK.Mumble.NotifierView comment: 
nil!

!GTK.Mumble.NotifierView class methodsFor: 'debugging attributes'!

debuggingPriority
    ^1
!

handleErrors
    ^handleErrors
!

handleErrors: aBoolean
    handleErrors := aBoolean
! !

!GTK.Mumble.NotifierView class methodsFor: 'instance creation'!

openOn: process message: message
    handleErrors := false.
    [ | wnd |
        Processor activeProcess name: 'Notifier/Debugger'.
        [ process isSuspended ] whileFalse: [ Processor yield ].

	"If we've just suspended the event loop, we'd better start 
	 another, otherwise we won't see the window!"
	
	"This test doesn't work because the process is a call-in process,
         not the original one (which is presumably blocking).
	 (Gtk activeDispatcherIs: process)"
	"FIXME This is a hack"
	(process name notNil and: [ process name match: 'call-in process' ])
	    ifTrue: [ Gtk newDispatcher ].
	
	(WindowView new) 
	    buildWidgets;
	    add: ( (self new) 
	        buildWidgets;
		init: message process: process;
		yourself);
	    defaultWidth: 200;
	    defaultHeight: 300;
	    show.

        handleErrors := true.
	Processor yield.
	"process resume."
    ] fork.

    process suspend.
! !

!GTK.Mumble.NotifierView methodsFor: 'private'!

add: aView
    super add: aView.
    vbox add: aView external.
!

buildWidgets
    | lbl btn hbox al |

    super buildWidgets.

    errorLbl := (GtkLabel new: 'Error') show; yourself.
    vbox add: errorLbl.
    errorLbl expand: false.

    tv isNil ifTrue: [ tv := LookupTreeView new. ].
    tm := StackTraceTreeModel new.
    tm initializeTreeView: tv.
    tv sorted: false.

    self add: tv.

    al := (GtkAlignment new: 0.5 yalign: 0.5 xscale: 0.3 yscale: 1.0) show; yourself.
    vbox add: al.
    al expand: false.

    hbox := (GtkHBox new: false spacing: 3) show; yourself.
    al add: hbox.

    btn := (GtkButton newWithLabel: 'Resume') show; yourself.
    hbox add: btn.
    btn on: 'clicked' send: #resumeClick to: self.

    btn := (GtkButton newWithLabel: 'Close') show; yourself.
    hbox add: btn.
    btn on: 'clicked' send: #ignoreClick to: self.
      
    self hookupPopupMenuTo: tv treeView.
!

closeWindow
    "FIXME - Need to hook window close and call ignoreClick"
    self windowView ifNotNil: [ :w | w close: self ].
!

ignoreClick
    "Kills the process and hence the original event loop, but we have a new
     one (the current process), started in init:process:"
    process terminate.
    self closeWindow.
!

init: aString process: aProcess
    | context lastContext contexts stacktrace |

    errorMsg := aString.
    errorLbl setText: aString.
    
    process := aProcess.

    context := process suspendedContext.
    lastContext := context environment.

    stacktrace := OrderedCollection new.

    "Skip top contexts that are internal to the exception-handling
     system."
    [ context ~~ lastContext and: [
        context isInternalExceptionHandlingContext ] ] whileTrue: [
            context := context parentContext.
    ].

    [ context == lastContext ] whileFalse: [
        context isDisabled ifFalse: [
	    stacktrace add: context printString
	].

        context := context parentContext.
    ].
    tm stacktrace: stacktrace.
!

resumeClick
    process resume.
    self closeWindow.
! !

!Behavior methodsFor: 'overriding'!

debuggerClass
    ^GTK.Mumble.NotifierView handleErrors
	ifTrue: [ GTK.Mumble.NotifierView ]
	ifFalse: [ nil ]
!
!

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

WindowedView subclass: #ScrollBox
	instanceVariableNames: 'box horizontal vport prefSize allocSize btns'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Views'!

GTK.Mumble.ScrollBox comment: 
nil!

!GTK.Mumble.ScrollBox class methodsFor: 'instance creation'!

new
    ^super new buildWidgets.!

new: aHorizontal
    ^(super new)
	horizontal: aHorizontal;
	buildWidgets.! !

!GTK.Mumble.ScrollBox methodsFor: 'accessing'!

add: aChild
    super add: aChild.
    vport add: aChild external
!

addWidget: aWidget
    vport add: aWidget
!

external
    ^box
!

hide
	"FIXME"
	box hideAll
!

horizontal
	horizontal isNil ifTrue: [ horizontal := true ].
	^horizontal
!

show
	"FIXME"
	box showAll
!

vport
	^vport
! !

!GTK.Mumble.ScrollBox methodsFor: 'events'!

scrollClick: aSender delta: aDelta
    | adj val |
    adj := vport getHadjustment.
    val := adj getValue + (aDelta * allocSize / 2).

    val := val max: 0.
    val := val min: (prefSize - allocSize).

    adj setValue: val.
!

sizeAllocate: aSender allocation: aAlloc
	| ws al vis |
	"For some reason, aAlloc doesn't seem to be very useful"
	ws := aSender castTo: GtkWidgetStruct type.
	al := ws allocation castTo: GtkAllocation type.
	allocSize := al width.
	(allocSize >= prefSize) 
		ifTrue: [ btns do: [ :each | each hide ] ]
		ifFalse: [ btns do: [ :each | each show ] ].
!

sizeRequest: aSender requisition: aReq
    self horizontal 
	ifTrue: [ 
	    prefSize := aReq width.
	    aReq width: 35.
	]
	ifFalse: [ 
	    prefSize := aReq height.
	    aReq height: 35. 
	].
! !

!GTK.Mumble.ScrollBox methodsFor: 'initialization'!

buildWidgets
    | adjs arrows |
    super buildWidgets.
    (self horizontal) 
        ifTrue: [     
	    box := GtkHBox new: false spacing: 0.
	    arrows := Array with: Gtk gtkArrowLeft with: Gtk gtkArrowRight.
        ]
	ifFalse: [ 
	    box := GtkVBox new: false spacing: 0.
	    arrows := Array with: Gtk gtkArrowUp with: Gtk gtkArrowDown.
	].

    btns := Array new: 2.
    1 to: 2 do: [ :i | | btn |
	btn := GtkButton new.
	btns at: i put: btn.
	btn add: (
	    GtkArrow 
		new: (arrows at: i)
		shadowType: Gtk gtkShadowNone).
	btn on: 'clicked' send: #scrollClick:delta: to: self with: ((2 * i) - 3).
    ].

    vport := GtkViewport new: nil vadjustment: nil.
    vport 
	on: 'size-request' send: #sizeRequest:requisition: to: self;
	on: 'size-allocate' send: #sizeAllocate:allocation: to: self.

    box 
	packStart: (btns at: 1) expand: false fill: true padding: 0;
	packStart: vport expand: true fill: true padding: 0;
	packEnd: (btns at: 2) expand: false fill: true padding: 0.	

    ^self
!

horizontal: aValue
    horizontal := aValue.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LookupTreeModel subclass: #MethodTreeModel
	instanceVariableNames: 'displayClass inheritedMode protocols listMode '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Data Structures'!

GTK.Mumble.MethodTreeModel comment: 
nil!

!GTK.Mumble.MethodTreeModel methodsFor: 'accessing'!

addProtocolNodesTo: aDictionary for: aClass
    | inh |
    inh := aClass ~= displayClass and: [ aClass ~= displayClass class ].
    aClass methodDictionary ifNotNil: [ :md |
	md keysAndValuesDo: [ :sel :cm |
	    (
		aDictionary 
		    at: cm methodCategory 
		    ifAbsentPut: [ 
			(ProtocolTreeNode 
			    new: #protocol label: cm methodCategory)
			    inherited: inh;
			    yourself
		    ]
	    ) add: cm.
	].
    ].
!

displayClass
    ^displayClass.!

displayClass: aClass
    displayClass := aClass.
    protocols := nil. 
    self rebuildModel.
!

getCols: aNode
    ^(aNode isKindOf: CompiledMethod)
	ifTrue: [ | mc sty |
	    mc := aNode methodClass.
	    sty := (mc = displayClass or: [ mc = displayClass class ])
		ifTrue: [ 'black' ]
		ifFalse: [ 'gray' ].
	    Array with: aNode selector asString with: sty.
	]
	ifFalse: [ | sty |
	    sty := aNode inherited 
	        ifFalse: [ 'black' ] 
                ifTrue: [ 'gray' ].
	    Array with: aNode label with: sty. 
	]!

getNodes: aNode
    ^(self listMode 
	  ifTrue: [ self getNodesForList: aNode ]
	  ifFalse: [ self getNodesForTree: aNode ])!

getNodesForList: aNode
    ^aNode isNil 
	ifTrue: [ nil ]
	ifFalse: [ self protocols values ]!

getNodesForTree: aNode
    aNode isNil ifTrue: [ ^self protocols children ].
    (aNode isKindOf: ProtocolTreeNode) ifTrue: [ ^aNode children ].
    ^nil.!

inheritedMode
    inheritedMode isNil ifTrue: [ inheritedMode := false ].  
    ^inheritedMode
!

inheritedMode: aBoolean
    inheritedMode = aBoolean ifTrue: [ ^self ].
    inheritedMode := aBoolean.
    self rebuildModel.
    self defaultExpand.
!

inheritedModeToggle
    self inheritedMode: (self inheritedMode not).
!

listMode
    listMode isNil ifTrue: [ listMode := false ].
    ^listMode
!

listMode: aBoolean
    listMode = aBoolean ifTrue: [ ^self ].
    listMode := aBoolean.
    self rebuildModel.
    self defaultExpand.
!

protocolNodesFor: aClass
    | dict |
    dict := Dictionary new.
    self inheritedMode 
	ifTrue: [ 
	    aClass withAllSuperclassesDo: [ :cls |
		self addProtocolNodesTo: dict for: cls.
	    ].
	]
	ifFalse: [
	    self addProtocolNodesTo: dict for: aClass.
	].
    ^dict values.!

protocols
    protocols isNil ifTrue: [ 
	protocols := ProtocolTreeNode new: #root label: ''.
	protocols children: (OrderedCollection new).
	protocols add: 
	    ((ProtocolTreeNode new: #meta label: 'Class Methods')
		children: (self protocolNodesFor: displayClass class);
	        yourself).
	protocols add:
	    ((ProtocolTreeNode new: #meta label: 'Instance Methods')
		children: (self protocolNodesFor: displayClass);
	        yourself).
    ].
    ^protocols.! !

!GTK.Mumble.MethodTreeModel methodsFor: 'events'!

promptFindMethod
    | pt sel |
    pt := Prompter 
	title: 'Find method' 
	entry: 'Method selector:'
	buttons: (Prompter buttonsOkCancel).
    [
	(pt showModal: view parentWindow) ifTrue: [ 
    	    sel := pt entry asSymbol.
	    (view find: [ :entry | 
		(entry isKindOf: CompiledMethod)
		  and: [entry selector = sel ]
	    ])
		ifNotNil: [ :it | view selectIter: it ].
	].
	pt close.
    ] fork.
! !

!GTK.Mumble.MethodTreeModel methodsFor: 'initialization'!

buildColumnsFor: aLookupTreeView
    | tree col rend typs |
    tree := GtkTreeStore newTypeNames: #('gint' 'gchararray' 'gchararray').
    aLookupTreeView tree: tree.

    col := GtkTreeViewColumn new.
    aLookupTreeView treeView insertColumn: col position: -1.
    col setTitle: 'Method'.
    col packStart: (rend := GtkCellRendererText new) expand: true.
    col	addAttribute: rend attribute: 'text' column: 1.
    "col addAttribute: rend attribute: 'foreground' column: 2."
!

initializeTreeView: aTV
    super initializeTreeView: aTV.
    self buildColumnsFor: aTV.
!

rebuildModel
    "protocols holds the nodes for the protocols, which otherwise are not
     represented by objects"
    protocols := nil. 
    super rebuildModel.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LabelledTreeView subclass: #ClassView
	instanceVariableNames: 'commentLbl varsLbl classVarsLbl superLblBtn '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.ClassView comment: 
nil!

!GTK.Mumble.ClassView methodsFor: 'accessing'!

classVars: aCollection
    classVarsLbl setLabel: (aCollection isEmpty 
         ifTrue: [ '(no class variables)' ] 
	ifFalse: [ aCollection asOrderedCollection joinStrings: ' ' ]).
!

comment: aComment
    commentLbl setLabel: aComment.
!

redisplay
    | cls |
    cls := tm displayClass.
    self 
	displayClass: nil;
	displayClass: cls.
!

displayClass: aClass
    self label: aClass printString.
    self superLabel: aClass superclass printString.
    self comment: (aClass comment ifNil: [ '(no comment)' ]).
    self classVars: aClass classVarNames.
    self vars: aClass instVarNames.
    tm displayClass: aClass.
    "Not sure why it needs hooking up again (not necessary for 
     NamespaceView), but it does."
    self hookupPopupMenuTo: tv treeView.
!

superLabel: aLabel
    superLblBtn getChild setMarkup: 
	'<i>', aLabel, ' >> </i>'.
!

vars: aCollection
    varsLbl setLabel: (aCollection isEmpty 
         ifTrue: [ '(no instance variables)' ] 
	ifFalse: [ aCollection joinStrings: ' ' ]).
! !

!GTK.Mumble.ClassView methodsFor: 'events'!

createVariablesEditor
    model ifNotNil: [ :m | m createVariablesEditor: tm displayClass ].
!

newMethodPrompt
    | s cls |
    s := tv selection ifNil: [ ^self ].
    Browser newMethodWindowFor:
	((s isKindOf: CompiledMethod) 
	    ifTrue: [ s methodClass ]
	    ifFalse: [ 
		s isClassNode 
		    ifTrue: [ tm displayClass class ]
		    ifFalse: [ tm displayClass ].
	    ]
        ).
!

promptInheritedVersions: aSender
    | pt |
    self fixme.
    pt := Prompter 
	title: 'Of which method' 
	entry: 'Method:'
	buttons: (Prompter buttonsOkCancel).
    pt showModal ifFalse: [ ^self ].
    
    aSender parentWindow displayClass.
    pt entry.
!

rebuildWindow
    super rebuildWindow.
    self displayClass: tm displayClass.
!

refresh
    self displayClass: tm displayClass.	
!

superClicked
	Browser createClassWindow: tm displayClass superclass! !

!GTK.Mumble.ClassView methodsFor: 'initialization'!

buildWidgets    
    | hbox vbox1 vbox2 btn al sw |
    super buildWidgets.

    tv isNil ifTrue: [ tv := LookupTreeView new. ].
    tm := MethodTreeModel new.
    tm initializeTreeView: tv.
    tv sorted: true.

    vbox add: (vbox1 := (GtkVBox new: false spacing: 0) show; yourself).
    vbox1 expand: false.
    vbox add: (vbox2 := (GtkVBox new: false spacing: 3) show; yourself).
    vbox2 expand: false.

    self add: tv.
	           
    (al := GtkAlignment new: 0.15 yalign: 0.5 xscale: 0.3 yscale: 1.0) show.
    al add: ((superLblBtn := GtkButton newWithLabel: '') show; yourself).
    superLblBtn 
	setRelief: Gtk gtkReliefNone;
	on: 'clicked' send: #superClicked to: self.

    "Move the title labels into the vbox"
    vbox1 add: al.
    al expand: false.
    lblBtn getParent 
	reparent: vbox1;
	expand: false.

    commentLbl := (GtkLabel new: 'commentLbl') show; yourself.
    classVarsLbl := (GtkLabel new: 'classVarsLbl') show; yourself.
    varsLbl := (GtkLabel new: 'varsLbl') show; yourself.

    "btn := (GtkButton new) show; yourself.
    btn add: ((GtkImage newFromFile: (Browser imageDir), '/edit.png') show; yourself).
    btn on: 'clicked' send: #createVariablesEditor: to: self with: false.
    vbox2 add: btn.
    btn expand: false."

    "(Array with: commentLbl with: classVarsLbl with: varsLbl) do: [ :each |
	vbox2 add: each.
	each expand: false.
    ]."

    sw := GtkScrolledWindow new: nil vadjustment: nil.
    sw 
	setShadowType: Gtk gtkShadowNone;
    	setPolicy: Gtk gtkPolicyAutomatic vscrollbarPolicy: Gtk gtkPolicyAutomatic.
    vbox2 add: sw.
    sw 
	expand: true;
    	addWithViewport: commentLbl.
    sw getChild setShadowType: Gtk gtkShadowNone.
    sw show.

    (Array with: classVarsLbl with: varsLbl) do: [ :each | | sb |
        sb := ScrollBox new.
	sb vport setShadowType: Gtk gtkShadowNone.
	sb show.
	vbox2 add: sb external.
	sb external expand: false.
	sb addWidget: each.
    ].

    lblBtn on: 'clicked' send: #refresh to: self.
    
    self hookupPopupMenuTo: tv treeView.
! 

buildMenuItems
    super buildMenuItems.
    menuItems
	section: 'Searching' add: 'Find method...' sending: #promptFindMethod to: tm;
	section: 'Editing' add: 'Change comment...' sending: #changeCommentPrompt to: self;
	section: 'Editing' add: 'Add/remove class variables...' sending: #changeClassVarsPrompt to: self;
	section: 'Editing' add: 'Add/remove instance variables...' sending: #changeInstVarsPrompt to: self;
	"section: '' add: ('Show all inherited methods' -> (tm -> #inheritedModeToggle));
	section: '' add: ('Show inherited definitions...' -> (self -> #promptInheritedVersions:));"
	section: 'Editing' add: 'New method...' sending: #newMethodPrompt to: self.
!
!

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

BrowserView subclass: #TestView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.TestView comment: 
nil!


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

LabelledTreeView subclass: #NamespaceView
	instanceVariableNames: 'treeMenuItems displayNamespace'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing'!

GTK.Mumble.NamespaceView comment: 
nil!

!GTK.Mumble.NamespaceView methodsFor: 'events'!

createSubclassOf: aClass named: aName
    | ns |
    "FIXME - Add to ChangeLog"
    ns := Namespace current.
    Namespace current: tm displayNamespace.
    aClass subclass: aName asSymbol
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: aClass category.
    Namespace current: ns.
!

fileOutClass: aClass to: aFileName
    | fs |
    fs := FileStream open: aFileName mode: FileStream write.
    
    aClass fileOutOn: fs.
    
    fs close.    
!

fileOutClassPrompt
    | cls pt fn fs |
    cls := tv selection.
    cls isNil ifTrue: [ 
	pt := Prompter 
	    title: 'No class is selected' 
	    entry: nil
	    buttons: (Prompter buttonsOk).
	[
	    (pt showModal: self).
	] fork.
	^self
    ].

    fn := 'changes/', (cls name ifNil: [ 'Unknown' ]), '.st'.

    pt := Prompter 
	title: ('Filing out ', cls name ifNil: [ 'Unknown' ]) 
	entry: 'File name: '
	buttons: (Prompter buttonsOkCancel).
    pt entry: fn.
    [
	(pt showModal: self) ifTrue: [ 
	    self fileOutClass: cls to: (self makeFileName: pt entry)
        ]
    ] fork.
!

makeFileName: aFileName
    "Strip out spaces, remove non-printing chars, etc."
    ^aFileName
!

subclassPrompt
    | cls pt |
    cls := tv selection.
    pt := Prompter 
	title: ('Create subclass of: ', cls name ifNil: [ 'Unknown' ]) 
	entry: 'Name: '
	buttons: (Prompter buttonsOkCancel).
    (pt run = Gtk gtkResponseOk) ifTrue: [ 
	self createSubclassOf: cls named: pt entryText
    ].
    pt destroy.
! !

!GTK.Mumble.NamespaceView methodsFor: 'initialization'!

buildWidgets
    super buildWidgets.
    
    tv isNil ifTrue: [ tv := LookupTreeView new. ].
    tm := ClassTreeModel new.
    tm initializeTreeView: tv.
    tv sorted: true.

    self add: tv.

    lblBtn on: 'clicked' send: #rebuildModel to: tm.

    self hookupPopupMenuTo: tv treeView.
    displayNamespace notNil ifTrue: [ self redisplay ].
!

redisplay
    self label: displayNamespace name.
    tm displayNamespace: displayNamespace.
!

treeMenuItems
    treeMenuItems isNil ifTrue: [
	treeMenuItems := MenuView new.
	treeMenuItems 
	    section: 'Filing' add: 'File out class...' sending: #fileOutClassPrompt to: self;
	    section: 'Editing' add: 'Subclass...' sending: #subclassPrompt to: self.
    ].
    ^treeMenuItems.
!

getPopupMenuItems: aMenuView forWidget: aWidget
    (aWidget = tv treeView) ifTrue: [
	aMenuView addAll: self treeMenuItems.
    ].
    ^aMenuView.
!

buildMenuItems
    super buildMenuItems.
    menuItems
	section: 'Searching' add: 'Find class...' sending: #promptFindClass to: tm.
!

displayNamespace: aNamespace
    displayNamespace := aNamespace.
    self redisplay.
!
!

Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

ChangeRecord subclass: #ExpressionChangeRecord
	instanceVariableNames: 'tgt exp '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Changes'!

GTK.Mumble.ExpressionChangeRecord comment: 
nil!

!GTK.Mumble.ExpressionChangeRecord methodsFor: 'accessing'!

exp
    ^exp
!

exp: anExpression
    exp := anExpression.
!

tgt
    ^tgt
!

tgt: aTarget
    tgt := aTarget
! !

!GTK.Mumble.ExpressionChangeRecord methodsFor: 'filing'!

fileOutChangeOn: aStream
    aStream 
	nextPutAll: 'Behavior evaluate: ';
	cr;
	nextPutAll: exp printString;
	cr;
	nextPutAll: ' to: ', tgt printString;
	cr;
	nextPutAll: '!';
	cr.
! !

!GTK.Mumble.ExpressionChangeRecord methodsFor: 'testing'!

= anObject
    (anObject isKindOf: ExpressionChangeRecord) ifFalse: [ ^super = anObject ].
    ^(anObject tgt = self tgt) and: [ anObject exp = self exp ]!

changeType
    ^#expressionChange
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

ChangeRecord subclass: #MethodChangeRecord
	instanceVariableNames: 'cls sel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Changes'!

GTK.Mumble.MethodChangeRecord comment: 
nil!

!GTK.Mumble.MethodChangeRecord methodsFor: 'accessing'!

cls
    ^cls
!

cls: aClass
    cls := aClass
!

sel
    ^sel
!

sel: aSelector
    sel := aSelector.
! !

!GTK.Mumble.MethodChangeRecord methodsFor: 'filing'!

fileOutChangeOn: aStream
    cls fileOutSelector: sel toStream: aStream.
    aStream cr.
! !

!GTK.Mumble.MethodChangeRecord methodsFor: 'testing'!

= anObject
    (anObject isKindOf: MethodChangeRecord) ifFalse: [ ^super = anObject ].
    ^(anObject cls = self cls) and: [ anObject sel = self sel ]!

changeType
    ^#methodChange
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #ClassDumper
	instanceVariableNames: 'toDump '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Changes'!

GTK.Mumble.ClassDumper comment: 
nil!

!GTK.Mumble.ClassDumper methodsFor: 'accessing'!

add: aClassOrNamespace
    toDump isNil ifTrue: [ toDump := Set new ].
    toDump add: aClassOrNamespace.
!

clear
    toDump := nil.
!

toDump
    ^toDump
! !

!GTK.Mumble.ClassDumper methodsFor: 'dumping'!

dependencyClassesFor: aClass
    | cls |
    "Dunno if this is the most efficient way..."
    cls := Set new.
    aClass methodDictionary ifNotNil: [ :md | 
	md values do: [ :cm |
	    cm literals ifNotNil: [ :ltls | 
		ltls do: [ :l |
		    (l isKindOf: VariableBinding) ifTrue: [
			cls add: l value.
		    ]
		]
	    ]
	].
    ].
    cls add: aClass superclass.
    cls remove: aClass ifAbsent: [].
    ^cls
!

fileOutOn: aStream
    self resolveDependencies do: [ :a | 
	"('Filing out ', a printString) printNl."
	aStream nextPutAll: ('Namespace current: ').
	a environment storeOn: aStream.
	aStream nextPut: $!; nl.
	Namespace current: a environment.
	a fileOutOn: aStream. 
    ].   
!

fileOutTo: aFileName
    | s |
    s := (File name: aFileName) writeStream.
    self fileOutOn: s.
    s flush; close.
    ('Filed out classes to ', aFileName) printNl.
!

resolveDependencies
    | resolved todo cls depsMap |
    todo := Set new: toDump size.
    toDump do: [ :a | 
	a isClass 
	    ifTrue: [ todo add: a ]
	    ifFalse: [ a allClassesDo: [ :b | todo add: b ] ].
    ].
    depsMap := Dictionary new: todo size.
    todo do: [ :a | depsMap at: a put: (self dependencyClassesFor: a) ].

    resolved := OrderedCollection new: todo size.

    [ | cl hist |
        cl := todo anyOne.
	hist := Set new.
	[ todo notEmpty ] whileTrue: [ | deps |
            deps := (depsMap at: cl).
            deps := deps select: [ :each | todo includes: each ].
            deps isEmpty 
		ifTrue: [ 
		    resolved add: cl.
		    todo remove: cl.
		    cl := todo anyOne.
		    hist empty.
		] 
		ifFalse: [ | cn |
		    depsMap at: cl put: deps.
		    cn := deps anyOne.
		    (hist includes: cn) ifTrue: [ 
			self error: 
			    'circular dependency between ', 
			    cl printString, ' and ', cn printString.
		    ].
		    cl := cn.
		].
        ].
    ] value.
	
    ^resolved.! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

BrowserView subclass: #EvaluatorView
	instanceVariableNames: 'object text textView changeLogBtns evalBtns '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

GTK.Mumble.EvaluatorView comment: 
nil!

!GTK.Mumble.EvaluatorView class methodsFor: 'experimentation'!

windowFor: aObject
    ^((WindowView new) buildWidgets)
	add: ((self new) 
	    object: aObject; 
	    buildWidgets);
	propertiesAt: 'default-width' put: 300;
	propertiesAt: 'default-height' put: 180;
	yourself.
! !

!GTK.Mumble.EvaluatorView methodsFor: 'experimentation'!

buildWidgets

    | btn lbl hbox frame scroll pol |

    super buildWidgets.

    vbox add: ((lbl := GtkLabel new: object printString) show; yourself).

    lbl expand: false.

    vbox add: ((frame := GtkFrame new: nil) show; yourself).
 
    text := GtkTextBuffer new: nil.
    "TODO 
    text applyTag: (text attribsFor: #monospaced) from: text getStartIter to: text getEndIter."

    frame add: (scroll := GtkScrolledWindow new: nil vadjustment: nil).
    pol := Gtk gtkPolicyNever.
    scroll setPolicy: pol vscrollbarPolicy: pol.
    scroll show.
    scroll add: ((textView := GtkTextView new) show; yourself).

    textView setBuffer: text.

    evalBtns := ((GtkAlignment new: 0.5 yalign: 0.5 xscale: 0.7 yscale: 1.0) show; yourself).
    vbox add: evalBtns.    
    evalBtns expand: false.

    evalBtns add: ((hbox := GtkHBox new: false spacing: 3) show; yourself). 

    hbox add: ((btn := GtkButton newWithLabel: 'Do it') show; yourself).
    btn on: 'clicked' send: #doItCallback to: self .

    hbox add: ((btn := GtkButton newWithLabel: 'Print it') show; yourself).
    btn on: 'clicked' send: #printItCallback to: self .

    hbox add: ((btn := GtkButton newWithLabel: 'Get it') show; yourself).
    btn on: 'clicked' send: #getItCallback to: self .

    changeLogBtns := GtkAlignment new: 0.5 yalign: 0.5 xscale: 0.7 yscale: 1.0. "Don't show"
    vbox add: changeLogBtns.    
    changeLogBtns expand: false.

    changeLogBtns add: ((hbox := GtkHBox new: false spacing: 3) show; yourself). 

    hbox add: ((btn := GtkButton newWithLabel: 'Log') show; yourself).
    btn on: 'clicked' send: #logCallback to: self .

    hbox add: ((btn := GtkButton newWithLabel: 'Close') show; yourself).
    btn on: 'clicked' send: #close to: self .

    text on: 'insert-text' send: #discardCallback to: self .
    text on: 'delete-range' send: #discardCallback to: self .
!

buildMenuItems
    super buildMenuItems.
    menuItems
	section: 'Templates' add: 'New class template' sending: #newClassTemplate to: self;
	section: 'Filing' add: 'Load file...' sending: #loadFilePrompt to: self;
	section: 'Filing' add: 'Save to file...' sending: #saveFilePrompt to: self;
	section: 'View' add: 'Use scrollbars' sending: #useScrollbarsCallback to: self.
!

discardCallback
    changeLogBtns hide.
!

doItCallback
    self evaluate
!

evaluate
    | result toEval sym |
    "FIXME"
    toEval := text getText.
    Transcript print: 'Evaluating: ', toEval.
    result := Behavior 
	evaluate: toEval
	to: object 
	ifError: [ :fname :line :msg | Transcript print: msg. ^self ].
    
    changeLogBtns show.

    ^result
!

getItCallback
    (EvaluatorView windowFor: (self evaluate)) show.
!

loadFilePrompt
    | dlg |
    dlg := FileSelection new: 'Load file'.
    (dlg run = Gtk gtkResponseOk) 
	ifTrue: [ 
	    text 
		setText: (File name: dlg filename) readStream contents
		len: -1.
	].
    dlg destroy.
!

logCallback
    "FIXME"
    CurrentChanges expressionChange: object -> text getText.
    changeLogBtns hide.
!

newClassTemplate
	text setText: 'ParentClass subclass: #Subclass
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''Uncategorized''' len: -1.
!

object: aObject
  object := aObject.
!

printItCallback
    (self evaluate) printNl.
!

saveFilePrompt
    | dlg |
    dlg := FileSelection new: 'Save file'.
    (dlg run = Gtk gtkResponseOk) 
	ifTrue: [ 
	    (File name: dlg filename) writeStream 
		nextPutAllFlush: text getText.
	].
    dlg destroy.
!

useScrollbarsCallback
    | pol |
    pol := Gtk gtkPolicyAutomatic.
    textView getParent setPolicy: pol vscrollbarPolicy: pol.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

BrowserView subclass: #VariablesEditor
	instanceVariableNames: 'displayClass clientHBox ctrlHBox currHBox newHBox newEdts '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browsing-Dialogs'!

GTK.Mumble.VariablesEditor comment: 
nil!

!GTK.Mumble.VariablesEditor methodsFor: 'initialization'!

addClick
    newHBox add: (Entry new: ('newEntry', (newHBox children size + 1) printString)).
!

buildVariableButtons
    currHBox children do: [ :each | currHBox remove: each ].

    displayClass instVarNames do: [ :var | | btn |
	currHBox add: (btn := ToggleButton new: ('btn', var) label: var).
	"btn relief: 'none'."
    ].

    
!

buildWidgets
    | btn | 
    super buildWidgets.
    self clientArea
	add: (clientHBox := HBox new: 'clientHBox').

    clientHBox 
	add: (currHBox := HBox new: 'currHBox');
	add: (newHBox := HBox new: 'newHBox');
	add: (ctrlHBox := HBox new: 'ctrlHBox').

    "currHBox expand: false.
    newHBox expand: false.
    clientHBox expand: false."

    ctrlHBox add: (btn := Button new: 'btnAdd').
    btn add: (GtkImage new: 'img' fromFile: 'images/add.png').
    btn on: 'clicked' send: #addClick to: self.
!

displayClass: aClass
    displayClass := aClass.
    self buildVariableButtons.
! !


Namespace current: Smalltalk.GTK.Mumble!
"Filed out from GNU Smalltalk version 2.1.7 on 14-Jan-2004  21:53:18"!

Smalltalk.Object subclass: #ChangeSet
	instanceVariableNames: 'changes '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Changes'!

GTK.Mumble.ChangeSet comment: 
nil!

!GTK.Mumble.ChangeSet methodsFor: 'accessing'!

add: aChangeSet
    aChangeSet changes do: [ :each | self addChange: each ].
!

changes 
    changes isNil ifTrue: [ changes := OrderedCollection new ].
    ^changes
!

clear
    self changes empty.
!

expressionChange: anAssoc
    | ec |

    ec := (ExpressionChangeRecord new) 
        tgt: (self globalFor: anAssoc key); 
	exp: anAssoc value; 
	yourself.
	   
    (self changes select: [ :each | each = ec ] ) do: [ :each |
	changes remove: each
    ].
    changes add: ec.
!

globalFor: anObject
    anObject isSymbol ifTrue: [ ^anObject ].
    Namespace current withAllSuperspacesDo: [ :each |
	(each keyAtValue: anObject) ifNotNil: [ :sym | ^sym ].
    ].
    ^nil.!

methodChange: anAssoc
    | mc |
    mc := (MethodChangeRecord new) 
        cls: anAssoc key; 
	sel: anAssoc value; 
	yourself.
	   
    (self changes select: [ :each | each = mc ] ) do: [ :each |
	changes remove: each
    ].
    changes add: mc.
! !

!GTK.Mumble.ChangeSet methodsFor: 'filing'!

fileOutChangesOn: aStream
    self changes do: [ :each |
	each fileOutChangeOn: aStream
    ].
!

fileOutChangesTo: aFileName
    self fileOutChangesTo: aFileName verbose: true.
!

fileOutChangesTo: aFileName verbose: aVerbose
    | fs |
    aVerbose ifTrue: [ Transcript print: 'Filing out changes to ', aFileName ].
    fs := (File name: aFileName) writeStream.
    self fileOutChangesOn: fs.
    fs close.
    aVerbose ifTrue: [ Transcript print: 'ok'; cr ].
! !

Smalltalk at: #CurrentChanges put: ChangeSet new.
!

