"======================================================================
|
|   Smalltalk Gtk+ bindings (hand-written methods).
|
 ======================================================================"


"======================================================================
|
| Copyright 2001, 2003 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

!GtkMessageDialog class methodsFor: 'instance creation'!

new: parent flags: flags type: type buttons: buttons message: message
    ^self
        new: parent
        flags: flags
        type: type
        buttons: buttons
        messageFormat: '%s'
        varargs: { message }! !

!GtkRequisition class methodsFor: 'instance creation'!

fromPoint: point
    | ba |
    ba := (CShortType arrayType: 2) new.
    ba at: 0 put: point x.
    ba at: 1 put: point y.
    ^(ba castTo: self type) addToBeFinalized; yourself! !

!GtkRequisition methodsFor: 'accessing'!

width
    | ba |
    ba := self castTo: (CIntType arrayType: 2).
    ^ba at: 0
!

height
    | ba |
    ba := self castTo: (CIntType arrayType: 2).
    ^ba at: 1
!

width: aWidth
    | ba |
    ba := self castTo: (CIntType arrayType: 2).
    ^ba at: 0 put: aWidth
!

height: aHeight
    | ba |
    ba := self castTo: (CIntType arrayType: 2).
    ^ba at: 1 put: aHeight
!
!

!GtkRequisition methodsFor: 'conversion'!

asPoint
    | ba |
    ba := self castTo: (CIntType arrayType: 2).
    ^(ba at: 0) @ (ba at: 1)!

!GdkRectangle class methodsFor: 'instance creation'!

fromRectangle: rect
    | ba |
    "Not yet tested - MA"
    ba := (CIntType arrayType: 4) new.
    ba at: 0 put: rect left.
    ba at: 1 put: rect top.
    ba at: 2 put: rect width.
    ba at: 3 put: rect height.
    ^(ba castTo: self type) addToBeFinalized; yourself! !

!GdkRectangle methodsFor: 'accessing'!

x
    ^(self at: 0 type: CIntType) value
!

y
    ^(self at: CIntType sizeof * 1 type: CIntType) value
!

width
    ^(self at: CIntType sizeof * 2 type: CIntType) value
!

height
    ^(self at: CIntType sizeof * 3 type: CIntType) value
!

left
    ^self x
!

top
    ^self y
!

right
    ^(self x + self width)
!

bottom
    ^(self y + self height)
!

origin
    ^self x @ self y
!

extent
    ^self width @ self height
!

corner
    ^self right @ self bottom
!
!

!GdkRectangle methodsFor: 'conversion'!

asRectangle
    ^self origin extent: self extent
! 
!

!GtkDialog methodsFor: 'accessing'!

vbox
    ^self at: (self class superclass cSizeof) type: GtkWidget
!
!

!GdkEventButton methodsFor: 'private'!

timeOffset
    ^CIntType sizeof + CPtr sizeof + CIntType sizeof "gint8, but not CByteType?"
!

buttonOffset
    ^(self class cSizeof)
        - (CDoubleType sizeof * 2) - CPtr sizeof - CIntType sizeof
!
!

!GdkEventButton methodsFor: 'accessing'!

button
    ^self at: self buttonOffset type: CIntType
!

time
    ^self at: self timeOffset type: CUIntType
!
!

!GdkEventConfigure methodsFor: 'private'!

coordOffset: aIndex
    ^(self class cSizeof) - (CIntType sizeof * (5 - aIndex)) 
!

!GdkEventConfigure methodsFor: 'accessing'!

x
    ^self at: (self coordOffset: 1) type: CIntType
!

y
    ^self at: (self coordOffset: 2) type: CIntType
!

width
    ^self at: (self coordOffset: 3) type: CIntType
!

height
    ^self at: (self coordOffset: 4) type: CIntType
!
!

!GtkWidget methodsFor: 'private'!

allocationOffset
    ^(self class cSizeof)
        - (CPtr sizeof * 2) - GtkAllocation cSizeof
!
!

!GtkWidget methodsFor: 'accessing'!

allocation
    ^self at: self allocationOffset type: GtkAllocation
!
!
