"======================================================================
|
|   Smalltalk Gtk+ bindings (functions in blox-gtk.c)
|
 ======================================================================"


"======================================================================
|
| Copyright 2001, 2003 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

"These differ from the standard implementation in that they run
 until all events are done.  We also need to redefine them so that
 they are asynchronous"
Gtk
	defineAsyncCFunc: 'bloxGtkMainIteration'
	withSelectorArgs: 'mainIteration'
	args: #( )!

Gtk
	defineAsyncCFunc: 'bloxGtkMainIterationDo'
	withSelectorArgs: 'mainIterationDo: blocking'
	args: #( #boolean )!

Gtk
	defineCFunc: 'bloxGtkShouldQuit'
	withSelectorArgs: 'shouldQuit'
	returning: #boolean
	args: #( )!

GLib class
	defineCFunc: 'bloxGtkRegisterForType'
	withSelectorArgs: 'register: anObject forType: gType'
	returning: #void
	args: #( #smalltalk #unknown )!

Gtk class defineCFunc: 'bloxGtkInit'
        withSelectorArgs: 'bloxGtkInit'
        returning: #void
        args: #()!

GObject
	defineCFunc: 'bloxGtkConnectSignal'
	withSelectorArgs: 'connectSignal: name to: handler selector: sel userData: userData'
	returning: #void
	args: #( #selfSmalltalk #string #smalltalk #smalltalk #smalltalk )!

GObject
	defineCFunc: 'bloxGtkNarrowGObjectOOP'
	withSelectorArgs: 'narrow'
	returning: #smalltalk
	args: #(#self #selfSmalltalk)!

GObject
	defineCFunc: 'bloxGtkFreeGObjectOOP'
	withSelectorArgs: 'free'
	returning: #void
	args: #(#self)!

GObject
	defineCFunc: 'bloxGtkGetProperty'
	withSelectorArgs: 'propertiesAt: name'
	returning: #smalltalk
	args: #( #self #string )!

GObject
	defineCFunc: 'bloxGtkSetProperty'
	withSelectorArgs: 'propertiesAt: name put: anObject'
	returning: #void
	args: #( #self #string #smalltalk )!

GtkWidget
	defineCFunc: 'bloxGtkGetWindow'
	withSelectorArgs: 'getWindow'
	returning: GdkWindow type
	args: #( #self )!

GtkWidget
	defineCFunc: 'bloxGtkGetFlags'
	withSelectorArgs: 'getFlags'
	returning: #int
	args: #( #self )!

GtkWidget
	defineCFunc: 'bloxGtkSetFlags'
	withSelectorArgs: 'setFlags: flags'
	returning: #void
	args: #( #self #int )!

GtkWidget
	defineCFunc: 'bloxGtkUnsetFlags'
	withSelectorArgs: 'unsetFlags: flags'
	returning: #void
	args: #( #self #int )!

GtkContainer
	defineCFunc: 'bloxGtkGetChildProperty'
	withSelectorArgs: 'child: widget propertiesAt: name'
	returning: #smalltalk
	args: #( #self #cObject #string )!

GtkContainer
	defineCFunc: 'bloxGtkSetChildProperty'
	withSelectorArgs: 'child: widget propertiesAt: name put: anObject'
	returning: #void
	args: #( #self #cObject #string #smalltalk )!

GtkTreeStore superclass: GtkTreeModel!

GtkListStore superclass: GtkTreeModel!

GtkTextIter class 
	defineCFunc: 'gtk_text_iter_sizeof'
	withSelectorArgs: 'sizeof'
	returning: #int
	args: #( #void )!

GtkTreeIter class 
	defineCFunc: 'gtk_tree_iter_sizeof'
	withSelectorArgs: 'sizeof'
	returning: #int
	args: #( #void )!

GValue class
	defineCFunc: 'g_type_from_name'
	withSelectorArgs: 'typeFromName: aName'
	returning: #int
	args: #( #string )!

GtkTreeModel 
	defineCFunc: 'gtk_tree_model_get_oop'
	withSelectorArgs: 'getOop: iter column: aColumn'
	returning: #smalltalk
	args: #( #self #cObject #int )!

GtkTreeStore
	defineCFunc: 'gtk_tree_store_set_oop'
	withSelectorArgs: 'setOop: iter column: aColumn value: aValue'
	returning: #void
	args: #( #self #cObject #int #smalltalk)!

GtkListStore
	defineCFunc: 'gtk_list_store_set_oop'
	withSelectorArgs: 'setOop: iter column: aColumn value: aValue'
	returning: #void
	args: #( #self #cObject #int #smalltalk )!

GtkDialog class
	defineCFunc: 'gtk_dialog_sizeof_c_struct'
	withSelectorArgs: 'sizeofCStruct'
	returning: #int
	args: #( #void )!
