"======================================================================
|
|   Smalltalk Gtk+ bindings (hand-written methods).
|
 ======================================================================"


"======================================================================
|
| Copyright 2001, 2003 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

!GtkMessageDialog class methodsFor: 'instance creation'!

new: parent flags: flags type: type buttons: buttons message: message
    ^self
        new: parent
        flags: flags
        type: type
        buttons: buttons
        messageFormat: '%s'
        varargs: { message }! !

!GtkRequisition class methodsFor: 'instance creation'!

fromPoint: point
    | req |
    req := self new.
    req width value: point x.
    req height value: point y.
    ^req
! 
!

!GtkRequisition methodsFor: 'conversion'!

asPoint
    ^(self width value) @ (self height value)    
!
!

!GdkRectangle class methodsFor: 'instance creation'!

fromRectangle: rect
    | rec |
    rec := self new.
    rec x value: rect left.
    rec y value: rect top.
    rec width value: rect width.
    rec height value: rect height.
!
!

!GdkRectangle methodsFor: 'accessing'!

left
    ^self x
!

top
    ^self y
!

right
    ^(self x + self width)
!

bottom
    ^(self y + self height)
!

origin
    ^self x @ self y
!

extent
    ^self width @ self height
!

corner
    ^self right @ self bottom
!
!

!GdkRectangle methodsFor: 'conversion'!

asRectangle
    ^self origin extent: self extent
! 
!

