    "gtktextlayout.h was not included in Makefile - list files using *.h?"

    "Removed placer.h from Makefile until such time as it works"

Object subclass: #StructDef
       instanceVariableNames: 'name parent fields'
       classVariableNames: 'tab typeLookup gNameLookup enums emitted deps'
       poolDictionaries: ''
       category: 'installation-postbootstrap'!

Object subclass: #StructsParser
       instanceVariableNames: 'fs structs currentLine tokens classNames emitted synonyms knownParent waiting ignore consts debugging structsSanity structsToParse'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'installation-postbootstrap'!

CharacterArray methodsFor: 'comparing'!

endsWith: aCharacterArray
    | n | 
    n := self size - aCharacterArray size.
    ^(n >= 0) and: [
	aCharacterArray keysAndValuesDo: [ :i :each |
	    (self at: i + n) = each ifFalse: [ ^false ]
	].
	true 
    ].
!

isGName
    ^#('G' 'Pango' 'Atk') 
	anySatisfy: [ :each | self  startsWith: each ].     
!

isFunctionName
    ^#('Func' 'Function' 'Callback' 'Notify') 
	anySatisfy: [ :each | self endsWith: each ].
!

isNumeric
    ^self allSatisfy: [ :ch | ch isDigit ].
!

includesString: aString
    ^(self indexOfSubCollection: aString ifAbsent: [ 0 ]) > 0
!
!

CharacterArray methodsFor: 'converting'!

replace: aString with: aReplaceString
    | i |
    i := self indexOfSubCollection: aString ifAbsent: [ ^self ].
    ^(self copyFrom: 1 to: i - 1), 
	aReplaceString, 
	(self copyFrom: i + aString size)
!

initialCap
    ^(self at: 1) asUppercase asString, (self copyFrom: 2) asLowercase.
!
!

SequenceableCollection methodsFor: 'convenience'!

join: aString
    ^self fold: [ :a :b | a printString, aString, b printString]   
!
!

StructDef class methodsFor: 'initialization'!

makeTab
    tab := Character tab asString.
!

makeEnums
    enums := Set new.
    enums add: 'GdkModifierType'. "FIXME"
!

makeEmitted
    emitted := Set new.
!

addEnum: aName
    enums add: aName.
!

makeTypeLookup
    typeLookup := Dictionary new.
    typeLookup 
	at: 'int' put: '#int';
	at: 'gchar' put: '#char';
	at: 'char' put: '#char';
	at: 'double' put: '#double';
	at: 'float' put: '#float';
	at: 'gfloat' put: '#float';
	at: 'gboolean' put: '#int';
	at: 'gint' put: '#int';
	at: 'gunichar' put: '#uLong'; "FIXME (#array #byte 4)';"
	at: 'gushort' put: '#uShort';
	at: 'gshort' put: '#short';
	at: 'guint' put: '#int';
	at: '*gchar' put: '#string';
	at: 'gpointer' put: '#(#ptr #int)';
	at: 'gconstpointer' put: '#(#ptr #int)';
	at: 'gdouble' put: '#double';
	at: 'guchar' put: '#uChar';
	at: 'GTypeInstance' put: '#uLong';	
	at: 'GType' put: '#uLong'; "Defined in gtype.h"
	at: 'gulong' put: '#int';
	at: 'guint64' put: '#(#array #byte 8)';
	"at: '*GData' put: '#(#ptr #int)';"
	at: 'union' put: '#(#array #byte 8)';
	at: 'function' put: '#(#ptr #int)'.
    typeLookup at: 'GdkNativeWindow' put: '#int'. "FIXME"
    typeLookup at: 'GdkAtom' put: '#(#ptr #int)'. "FIXME"
    typeLookup at: 'GdkCursorType' put: '#int'.
    typeLookup at: 'GQuark' put: '#(#array #byte 4)'.
    typeLookup at: 'GTimeVal' put: '#(#array #long 2)'.
!

addGNameLookup: aName
    gNameLookup isNil ifTrue: [ gNameLookup := Dictionary new ].
    gNameLookup at: aName put: '#{', aName, '}'.
!
!

StructDef methodsFor: 'initialization'!

name: aName 
    name := aName.
!

parent: aParent
    self addDependency: aParent.
    parent := aParent.
!

name
    ^name
!

parent
    ^parent
!

fields
    fields isNil ifTrue: [ fields := OrderedCollection new ].
    ^fields.
!

deps
    deps isNil ifTrue: [ ^#() ].
    ^deps at: self name ifAbsent: [ #() ].
!
!

StructDef class methodsFor: 'dependencies'!

addDependency: aType for: aName
    | set |
    deps isNil ifTrue: [ deps := Dictionary new ].
    set := deps at: aName ifAbsentPut: [ Set new ].
    set add: aType
!
!

StructDef methodsFor: 'accessing'!

smalltalkize: aName
    | words res |
    "Fix leading underscore"
    words := aName subStrings: $_.
    res := words first.
    (words copyFrom: 2) do: [ :word |
	res := res, word first asUppercase asString, (word copyFrom: 2).
    ].
    ^res
!

addDependency: aType
    self class addDependency: aType for: self name.
!

internalAdd: aName type: aType
    self fields add: aName -> aType.
!

translateBits: aType index: aIndex
    | n rb |
    "Emit gint8, gint64, guint32, etc. as byte or byte arrays"
    
    rb := [ :typeName |
	(aType at: aIndex - 1) = $u
	    ifTrue: [ '#u', typeName initialCap ]
	    ifFalse: [ '#', typeName ].
    ].

    n := (aType copyFrom: aIndex + 3) asInteger.

    n = 32 ifTrue: [ ^rb value: 'int' ].
    n = 8 ifTrue: [ ^rb value: 'char' ].
    n = 16 ifTrue: [ ^rb value: 'short' ].

    n := n / 8.
    ^(n = 1 ifTrue: [ '#byte' ]
	    ifFalse: [ '#(#array #byte ', n displayString, ')' ]).
!

translateType: aType allowFail: aCanFail
    | i |
    typeLookup at: aType ifPresent: [ :t | ^t ].
    gNameLookup at: aType ifPresent: [ :t | self addDependency: aType. ^t ].
    (enums includes: aType) ifTrue: [ ^'#int' ].
    aType isGName ifTrue: [ 
	aType isFunctionName 
	    ifTrue: [ ^'#(#ptr #int)' ]
	    ifFalse: [ "FIXME"
		(emitted includes: aType) ifTrue: [ ^'#', aType ].
		aCanFail ifTrue: [ ^nil ].
		aType = 'GdkModifierType' ifTrue: [
		    'GdkModifierType' printNl.
		    enums printNl.
		    ].
		self error: 'Unknown non-pointer GName ', aType printString.
		"^'#int'" 
	    ].  
    ].
    (aType last isDigit
	and: [ (i := aType indexOfSubCollection: 'int') > 0 ]) 
	ifTrue: [ ^self translateBits: aType index: i ].
    (aType startsWith: '_') 
	ifTrue: [ ^self translateType: (aType copyFrom: 2) allowFail: aCanFail.	].
    aCanFail ifTrue: [ ^nil ].
    self error: 'Unknown type: ', aType.
!

translateType: aType
    ^self translateType: aType allowFail: false.
!

tryTranslateType: aType
    ^self translateType: aType allowFail: true.
!

addSimpleDecl: aName type: aType
    self internalAdd: aName type: #simple -> aType.
!

addPointerDecl: aName type: aType
    self internalAdd: aName type: #ptr -> aType.
!


addArrayDecl: aName type: aType size: aSize
    self internalAdd: aName type: #array -> (aType -> aSize).
!
!

StructDef methodsFor: 'printing'!

emit    
    "name print. 
    ' printNl!' displayNl."
    emitted add: self name.
    fields isNil
	ifTrue: [ self emitVariableWordSubclass ]
	ifFalse: [ self emitCStructDefinition ].
!

emitVariableWordSubclass
    "name = 'GtkAllocation' ifTrue: [ self error: 'halt' ]."
    ('%1 variableWordSubclass: #%2' bindWith: parent with: name) displayNl.
    (tab, 'instanceVariableNames: ''''') displayNl.
    (tab, 'classVariableNames: ''''') displayNl.
    (tab, 'poolDictionaries: ''''') displayNl.
    (tab, 'category: ''Gtk''!') displayNl.
    '' displayNl.
!

pointerTypeDeclFrom: aType
    (self tryTranslateType: '*', aType) ifNotNil: [ :t | ^t ].
    (self tryTranslateType: aType) 
	ifNotNil: [ :t | ^('#(#ptr ', (self translateType: aType), ')') ].
    "'void *'"
    ^'#(#ptr #int)'.
!

arrayTypeDeclFrom: aType
    ^('#(#array ', (self translateType: aType key), ' ', aType value displayString, ')').
!

typeDeclFrom: aType
    aType key = #ptr ifTrue: [ ^self pointerTypeDeclFrom: aType value ].
    aType key = #array ifTrue: [ ^self arrayTypeDeclFrom: aType value ].
    ^self translateType: aType value.
!

emitFieldsDeclaration
    fields do: [ :each | 
	(tab, tab, '#(#', (self smalltalkize: each key), ' ', 
	     (self typeDeclFrom: each value), ')')
	    displayNl. 
    ].
!

emitCStructDefinition
    ('%1 subclass: #%2' bindWith: parent with: name) displayNl.
    (tab, 'declaration: #( ') displayNl.
    self emitFieldsDeclaration.
    (tab, ')') displayNl.
    (tab, 'classVariableNames: ''''') displayNl.
    (tab, 'poolDictionaries: ''''') displayNl.
    (tab, 'category: ''''!') displayNl.
    '!' displayNl.
!
!

StructDef makeTab; makeEnums; makeEmitted; makeTypeLookup.
!

StructsParser methodsFor: 'parsing'!

debugging: aInteger
    debugging := aInteger.
!

makeStructsSanityChecklist
    | fs ign |
				     
    fs := (File name: 'funcs-classes.txt') readStream.
    (ign := ignore copy) addAll: #('Pango' 'Gdk' 'GdkPixbuf' 'Gtk').
    [ fs atEnd ] 
	whileFalse: [ | next | 
	    next := fs nextLine trimSeparators.
	    (ign includes: next)
		ifFalse: [ structsSanity add: next ].
	].
!

parseArgv 
    self doBegin.
    
    1 to: Smalltalk getArgc do: [ :i | 
	"self parseFileList: (Smalltalk getArgv: i)."
	self parseFile: (Smalltalk getArgv: i).
    ].
    self doEnd.
!

parseFileList: aFileList
    | rs |
    rs := (File name: aFileList) readStream.
    [ rs atEnd ] 
	whileFalse: [ self parseFile: rs nextLine ].
!

printArgv
    1 to: Smalltalk getArgc do: [ :i | 
	(Smalltalk getArgv: i) printNl
    ].
!

parseFile: aFileName
    "('parsing ', aFileName) printNl."
    self parseStream: (File name: aFileName) readStream.
!

parseStream: aStream
    fs := aStream.
    [ fs atEnd ] whileFalse: [ self parseInitial ].
!

initialize
    classNames := Set new.
    emitted := Set new.
    waiting := Dictionary new.
    synonyms := Dictionary new.
    knownParent := Dictionary new.
    ignore := Set new.
    consts := Dictionary new.
    structsToParse := Set new.
    structsSanity := OrderedCollection new.
!

removeCommentFrom: aString
    | rs i |
    rs := aString.
    i := aString indexOfSubCollection: '/*' startingAt: 1.
    (i > 0) ifTrue: [ | j |
	rs := (aString copyFrom: 1 to: i - 1).
        j := aString indexOfSubCollection: '*/' startingAt: i.
	(j > 0) ifTrue: [ rs := rs, (aString copyFrom: j + 2) ].
    ].
!

readNextLine
    | i tmp prevLine end |
    prevLine := currentLine.
    end := fs atEnd.
    currentLine := fs nextLine.
    currentLine isNil ifTrue: [ 
	end ifTrue: [ 'that was expected' printNl ]
	    ifFalse: [ 'that was UNexpected' printNl ].
	self error: 'Need EOF check'
    ].

    tmp := currentLine.
    i := currentLine indexOfSubCollection: '/*' startingAt: 1.
    (i > 0) ifTrue: [ | j |
	tmp := (currentLine copyFrom: 1 to: i - 1).
	j := currentLine indexOfSubCollection: '*/' startingAt: i.
	[ j > 0 ]
	    whileFalse: [ 
		fs atEnd ifTrue: [ self error: 'EOF inside comment' ].
		currentLine := fs nextLine.
		j := currentLine indexOfSubCollection: '*/'.
	    ].
	tmp := tmp, (currentLine copyFrom: j + 2).
    ].
    currentLine := tmp.
    tokens := currentLine subStrings.
!

parseInitial
    | i src dest isTypedef isStruct isVtableDecl isGName isEnum isPointer name |

    currentLine := fs nextLine.    
    currentLine := currentLine reject: [ :ch | '_;' includes: ch ].
    tokens := currentLine subStrings.
    
    tokens isEmpty ifTrue: [ ^self ].

    isTypedef := (tokens at: 1) = 'typedef'.
	"#('struct' 'typedef') anySatisfy: [ :each | (tokens at: 1) = each ]."
    i := 1 + isTypedef asCBooleanValue.
    isStruct := #('struct' 'union') 
	anySatisfy: [ :each | (tokens at: i ifAbsent: [ '' ]) = each ].

    isTypedef 
	ifTrue: [
	    src := tokens at: i + isStruct asCBooleanValue ifAbsent: [ '' ].
	    dest := tokens at: 3 + isStruct asCBooleanValue ifAbsent: [ '' ].
	    isVtableDecl := #('Class' 'Iface') 
		anySatisfy: [ :each | src endsWith: each ].
	    isGName := src isGName.
	    isPointer := dest includes: $*.
	]
	ifFalse: [
	    isStruct ifTrue: [ 
		name := tokens at: 2. 
		isGName := name isGName.
	    ].
	    isPointer := false.
	].

    isEnum := isStruct not 
	and: [ (tokens at: 1 + isTypedef asCBooleanValue) = 'enum' ].
    isEnum ifTrue: [ ^self parseEnum ].

    (isTypedef & isStruct & isGName & ((src = dest) | (('_', src) = dest))) 
	ifTrue: [
	    isVtableDecl ifFalse: [ 
		classNames add: src.
		^self.
	    ]
        ].

     (isTypedef & isGName & (isPointer not)) ifTrue: [
	 "Take into account typedefs from a struct named differently.
          We emit all these at the end, because they're often forward
	  references."
	 self foundSynonym: src for: dest.
	 ^self
     ].

     isStruct & (classNames includes: name) ifFalse: [ ^self ].

     self parseStruct: name.
!

foundSynonym: aSrc for: aDest
    (emitted includes: aSrc) 
	ifTrue: [
	    self emitSyn: aDest parent: aSrc.
	]
	ifFalse: [
	    self addSynonym: aDest for: aSrc
	].
!

parseStruct: aName
    | def last parsing pt |

    ('''', aName, ''' printNl!') displayNl.

    (aName startsWith: '*') ifTrue: [ self error: 'aName * ', aName].
    def := StructDef new.
    def name: aName.

    parsing := structsToParse includes: aName.

    "Read the first line - check if it is a parent"
    [ currentLine includes: ${ ] 
	whileFalse: [ self readNextLine. ].
    [ self readNextLine. currentLine allSatisfy: [ :ch | ch isSeparator ] ]
	whileTrue.
    
    def parent: (
	knownParent 
	    at: aName 
	    ifAbsent: [ 
		"Look to see if the first definition line looks like a parent class"
		pt := 
		    ((emitted includes: (tokens at: 1))
			 and: [
			     ((tokens at: 2) startsWith: '*') not
				 and: [ (tokens at: 1) isGName ]
			 ])
		    ifTrue: [ | tok |
			"It does - take the first token as the name"
			tok := tokens at: 1.
			self readNextLine.
			tok.
		    ]
		    ifFalse: [ 
			'CStruct'.
		    ].
	    ]
    ).


    [ 
	self parseDefinitionFor: def discard: parsing not.
    ]
	whileFalse: [ 
	    fs atEnd 
		ifTrue: [ self error: 'EOF inside struct' ]
		ifFalse: [ self readNextLine ].
	].

    (ignore includes: def name) 
	ifFalse: [ self emitStruct: def. ]
	ifTrue: [ 
	    (waiting includesKey: def name) 
		ifTrue: [ 
		    '''- substituting found definition'' printNl!' displayNl.
		    self emitStruct: (waiting at: def name).
		]
		ifFalse: [ '''- ignored'' printNl!' displayNl ].
	].
!

readDefinition
    | defLine j |
    defLine := ''.
    [ 
	defLine := defLine, currentLine. 
	currentLine anySatisfy: [ :ch | #($; $}) includes: ch ]
    ] 
	whileFalse: [ self readNextLine ].   

    "Strip whitespace from front"
    j := defLine findFirst: [ :ch | ch isSeparator not ].
    (j = 0) ifTrue: [ self error: 'Empty definition' ].
    defLine := defLine copyFrom: j.

    "signed and const are of no interest to us"
    #('struct' 'signed' 'unsigned' 'const') do: [ :each |
	(defLine startsWith: each) ifTrue: [
	    defLine := defLine copyFrom: (each size + 1).
	    j := defLine findFirst: [ :ch | ch isSeparator not ].
	    (j = 0) ifTrue: [ self error: 'Empty definition?!' ].
	    defLine := defLine copyFrom: j.
	]
    ].

    ^defLine.
!

parseDefinitionFor: aDef discard: aDiscard
    | defLine type name ptr i j tok2 last array |

    "Skip blank lines"
    (currentLine allSatisfy: [ :ch | ch isSeparator ])
	ifTrue: [ self readNextLine ].
    "Trim rubbish from back (and check for last defn)"
    i := currentLine indexOf: $} ifAbsent: [ 0 ].
    (last := (i > 0)) ifTrue: [
	"Assume that there's nothing of interest past the }"
	currentLine := currentLine copyFrom: 1 to: i - 1.
	(currentLine anySatisfy: [ :ch | ch isSeparator not ]) 
	    ifFalse: [ ^last ].
    ].

    "Strip out a definition"
    defLine := self readDefinition.     

    aDiscard ifTrue: [ ^last ].

    "First token is type"
    j := defLine findFirst: [ :ch | ch isSeparator or: [ ch = $* ] ].
    type := defLine copyFrom: 1 to: j - 1.
    defLine := defLine copyFrom: j.

    "Collect *s"
    ptr := WriteStream on: (String new).
    j := 1.
    [ | ch |
	ch := defLine at: j. 
	ch isSeparator or: [ 
	    (ch = $*) 
		ifTrue: [ ptr nextPut: ch. true ] 
		ifFalse: [ false ].
	]
    ] 
	whileTrue: [ j := j + 1 ].
    ptr := ptr contents.
    defLine := defLine copyFrom: j.

    "Next param is field name for a simple field"
    j := defLine findFirst: [ :ch | (ch isAlphaNumeric or: [ ch = $_ ]) not ].
    (j = 1) 
	ifTrue: [
	    "Yikes - maybe a function pointer or a union?"
	    (defLine startsWith: '(*') 
		ifTrue: [ self parseFunction: defLine for: aDef. ^last ].
            (defLine startsWith: '{') 
		ifTrue: [ self parseUnion: defLine for: aDef. ^last ].
	    (defLine startsWith: '#define')
		ifTrue: [ ^last "duh" ].
	     aDef name printNl. self error: 'Can''t interpret ', defLine.
	]. 
    name := defLine copyFrom: 1 to: j - 1.
    defLine := defLine copyFrom: j.
    (defLine startsWith: ' ') ifTrue: [ defLine := defLine trimSeparators ].
    (defLine startsWith: '[') ifTrue: [ array := self parseArray: defLine ].

    ptr notEmpty ifTrue: [ 
	(ptr size > 1) ifTrue: [ self error: 'double pointer' ].
	aDef addPointerDecl: name type: type. ^last .
    ].
    array notNil ifTrue: [ aDef addArrayDecl: name type: type size: array. ^last ].
    aDef addSimpleDecl: name type: type.
    
    "Multiple declarations on one line - assuming they are all simple"
    [ defLine startsWith: ',' ] 
	whileTrue: [  
	    '"Multiple declarations..."' displayNl.
	    defLine := (defLine copyFrom: 2) trimSeparators.
	    j := defLine findFirst: [ :ch | (ch isAlphaNumeric or: [ ch = $_ ]) not ].
	    name := defLine copyFrom: 1 to: j - 1.
	    defLine := (defLine copyFrom: j) trimSeparators.
	    aDef addSimpleDecl: name type: type.
	].
    ^last
!

parseArray: aDefLine
    | size |
    size := (aDefLine 
		 copyFrom: 2 
		 to: (aDefLine findFirst: [ :ch | ch = $] ]) - 1
		 ) trimSeparators.
    size isNumeric ifTrue: [ ^size ].
    ('''', size, ''' printNl!') displayNl.
    consts keysAndValuesDo: [ :const :value |
	('''', const, ' => ', value, ''' printNl!') displayNl.
	size := size replace: const with: value
    ].
    ('''Evaluating ', size, ''' printNl!') displayNl.
    ^(Behavior evaluate: size) displayString
!

parseUnion: aDefLine for: aDef
    | defLine j name array |
    "FIXME - Arrays"
    "Swallow the definition"
    defLine := aDefLine.
    [ currentLine includes: $} ] 
	whileFalse: [ self readNextLine ].
    defLine := currentLine copyFrom: (defLine findFirst: [ :ch | ch = $} ]) + 1.
    defLine := defLine copyFrom: (defLine findFirst: [ :ch | ch isAlphaNumeric ]).
    j := defLine findFirst: [ :ch | (ch isAlphaNumeric or: [ ch = $_ ]) not ].
    name := defLine copyFrom: 1 to: j - 1.
    "One of the GValue-related classes contains an array of union"
    (defLine startsWith: '[') ifTrue: [ array := self parseArray: defLine ].

    array isNil 
	ifTrue: [ aDef addSimpleDecl: name type: 'union' ]
	ifFalse: [ aDef addArrayDecl: name type: 'union' size: array ]
!

parseFunction: aDefLine for: aDef
    | defLine |
    defLine := aDefLine.
    defLine := defLine 
	copyFrom: (defLine findFirst: [ :ch | ch isAlphaNumeric or: [ ch = $_ ] ] ).
    defLine := defLine 
	copyFrom: 1 
	to:  (defLine findFirst: [ :ch | (ch isAlphaNumeric or: [ ch = $_ ]) not ] ) - 1.	
    aDef addSimpleDecl: defLine type: 'function'.
!

parseEnum
    | i |

    '''Parsing enum ' display.

    "Read the first line - check if it is a parent"
    [ currentLine includes: ${ ] 
	whileFalse: [ self readNextLine. ].
    [ self readNextLine. currentLine allSatisfy: [ :ch | ch isSeparator ] ]
	whileTrue.

    [ 
	i := currentLine indexOf: $} ifAbsent: [ 0 ].
	i > 0 and: [ 
	    (currentLine indexOf: $; ifAbsent: [ 0 ]) > 0
	].
    ] whileFalse: [
	"Skip enum declaration - handled elsewhere"
	    self readNextLine.
        ].

    "Read name"
    currentLine := currentLine copyFrom: i + 1.
    currentLine := currentLine 
	copyFrom: (currentLine findFirst: [ :ch | ch isAlphaNumeric or: [ ch = $_ ]]).
    currentLine := currentLine 
	copyFrom: 1
	to: (currentLine findFirst: [ :ch | (ch isAlphaNumeric or: [ ch = $_ ]) not ]) - 1.
    
    StructDef addEnum: currentLine.    
    (currentLine, ''' printNl!') displayNl.
!

emitStruct: aDef
    | save i tab syns sd deps |
    "Dependencies are satisfied?"
    deps := aDef deps reject: [ :each | emitted includes: each ].
    deps notEmpty ifTrue: [
	deps copy do: [ :each | 
	    waiting at: each ifPresent: [ :def |
		(self emitStruct: def) 
		    ifTrue: [ deps remove: each ].
	    ].
	].
	deps isEmpty ifFalse: [ 
	    deps do: [ :each | each print ]. 
	    ('"', aDef name, ' is waiting on: ', 
		 (deps asOrderedCollection join: ','), '"') displayNl.
	    waiting at: aDef name put: aDef.
	    ^false
	].
    ].

    (emitted includes: aDef name) ifTrue: [ ^true ].

    aDef emit.
    emitted add: aDef name.
    waiting removeKey: aDef name ifAbsent: [].
    classNames remove: aDef name ifAbsent: [].
    StructDef addGNameLookup: aDef name.

    syns := synonyms at: aDef name ifAbsent: [ ^true ].
    synonyms removeKey: aDef name.
    syns do: [ :each | self emitSyn: each parent: aDef name ].

    ^true
!

emitSyn: aName parent: aParent
    | def |
    def := StructDef new.
    def 
	name: aName;
	parent: aParent;
	emit.
    emitted add: aName.
!

addSynonym: aDest for: aSrc
    aDest = aSrc ifTrue: [ ^self ].
    (synonyms at: aSrc ifAbsentPut: [ Set new ])
	add: aDest.
!

addWaitingDef: aName parent: aParent
    ^waiting at: aName put: ((StructDef new) name: aName; parent: aParent).
!

addWaitingDefs
    "GtkEditable - 'interface'"
    self addWaitingDef: 'GtkEditable' parent: 'GtkWidget'.

    "GtkAllocation - Synonym"
    self addWaitingDef: 'GtkAllocation' parent: 'GdkRectangle'.

    "GParamSpecPool - Defined in gparam.c => private"
    self addWaitingDef: 'GParamSpecPool' parent: 'CStruct'.

    "PangoLanguage - /* Dummy typedef - internally it's a 'const char *' */ - from pango-types.h"
    self addWaitingDef: 'PangoLanguage' parent: 'CStruct'.

    "PangoFontsetSimple - FIXME - Not actually a synonym, but defined in pango-fontset.c => private"
    self addWaitingDef: 'PangoFontsetSimple' parent: 'PangoFontset'.

    "PangoTabArray - FIXME - Not actually a synonym, but defined in pango-tabs.c => private"
    self addWaitingDef: 'PangoTabArray' parent: 'PangoFontset'.

    "PangoLayout - FIXME - Not actually a synonym, but defined in pango-layout.c => private"
    self addWaitingDef: 'PangoLayout' parent: 'GObject'.

    "PangoFontDescription - FIXME - Not actually a synonym, but defined in fonts.c => private"
    self addWaitingDef: 'PangoFontDescription' parent: 'CStruct'.

    "PangoAttrList - FIXME - Not actually a synonym, but defined in pango-attributes.c => private"
    self addWaitingDef: 'PangoAttrList' parent: 'CStruct'.

    "GdkDisplayManager - A synonym, defined in gdkdisplaymanager.c"
    self addWaitingDef: 'GdkDisplayManager' parent: 'GObject'.

    "GtkTreePath - Defined in gtktreemodel.c => private"
    self addWaitingDef: 'GtkTreePath' parent: 'CStruct'.

    "GtkTreeRowReference - Defined in gtktreemodel.c => private"
    self addWaitingDef: 'GtkTreeRowReference' parent: 'CStruct'.

    "GtkTreeModel - /* Dummy typedef - from gtktreemodel.h */"
    self addWaitingDef: 'GtkTreeModel' parent: 'CStruct'.

    "GtkClipboard - Defined in gtkclipboard.c => private"
    self addWaitingDef: 'GtkClipboard' parent: 'GObject'.

    "GtkIconSet - Defined in gtkiconfactory.c => private"
    self addWaitingDef: 'GtkIconSet' parent: 'CStruct'.

    "GtkIconSource - Defined in gtkiconfactory.c => private"
    self addWaitingDef: 'GtkIconSource' parent: 'CStruct'.

    "GtkNotebookPage - Defined in gtknotebook.c => private"
    self addWaitingDef: 'GtkNotebookPage' parent: 'CStruct'.

    "GdkRegion - FIXME - Defined in gdkregion-generic.h, which doesn't seem to get installed for some reason - not empty - is it needed?"
    self addWaitingDef: 'GdkRegion' parent: 'CStruct'.

    "GData - from gdataset.c => private"
    self addWaitingDef: 'GData' parent: 'CStruct'.

    "GdkEvent"
    self addWaitingDef: 'GdkEvent' parent: 'CStruct'. "Really a union"
!

addStructsToParse
    structsToParse 
	add: 'GdkRectangle'; 
	add: 'GtkRequisition'.
    #('GdkEventAny' 'GdkEventExpose' 'GdkEventNoExpose' 'GdkEventVisibility' 
	  'GdkEventMotion' 'GdkEventButton' 'GdkEventScroll' 'GdkEventKey' 'GdkEventCrossing' 
	  'GdkEventFocus' 'GdkEventConfigure' 'GdkEventProperty' 'GdkEventSelection' 
	  'GdkEventProximity' 'GdkEventClient' 'GdkEventDND' 'GdkEventWindowState' 
	  'GdkEventSetting' ) do: [ :each | structsToParse add: each ].
!

addKnownParents
    "GtkEditable is a dummy class - an interface in C - so we must set inheritance manually"
    knownParent 
	at: 'GtkEntry' put: 'GtkEditable';
	at: 'GtkEditable' put: 'GtkWidget'.
    knownParent 
	at: 'GtkTreeStore' put: 'GtkTreeModel';
	at: 'GtkListStore' put: 'GtkTreeModel'.
    knownParent 
	at: 'GtkDialog' put: 'GtkWindow'.
    "Really, we'd have GdkEventAny as the parent of all these, but then we can't
     easily parse them automatically."
    #('GdkEventAny' 'GdkEventExpose' 'GdkEventNoExpose' 'GdkEventVisibility' 
	  'GdkEventMotion' 'GdkEventButton' 'GdkEventScroll' 'GdkEventKey' 'GdkEventCrossing' 
	  'GdkEventFocus' 'GdkEventConfigure' 'GdkEventProperty' 'GdkEventSelection' 
	  'GdkEventProximity' 'GdkEventClient' 'GdkEventDND' 'GdkEventWindowState' 
	  'GdkEventSetting' ) do: [ :each | knownParent at: each put: 'GdkEvent' ].
	      
!

doBegin
    "FIXME - Pick this up automatically?"
    consts 
	at: 'GDK_MAX_TIMECOORD_AXES' put: '128';
	at: 'GDK_AXIS_LAST' put: '7';
	at: 'GTK_MAX_COMPOSE_LEN' put: '7'.

    "Here starts the class hierarchy"
    emitted 
	add: 'CObject';
	add: 'CStruct'.

    "These are implemented strangely..."
    #('GValue' 'GtkObject' 'GtkEditable')
	do: [ :each | classNames add: each ].
 
    self addKnownParents.
    self addStructsToParse.
    self addWaitingDefs.

    "These don't picked up otherwise."
    #('GdkColor')
	do: [ :each | 
	    classNames add: each.
	    StructDef addGNameLookup: each.
	].

    "hackish fixup"
    StructDef addDependency: 'GdkColor' for: 'GtkStyle'.

    ignore
	add: 'GObjectConstructParam';
	add: 'GdkEvent'; "Actually a union - dummy def in waitingDefs"
	add: 'GQuark';
	"add: 'GtkContainer'; ""Awkward def - manual def in waitingDefs"
	add: 'GtkCellEditable'. "FIXME - not needed anyway?"

    "End of setup"
    debugging notNil ifTrue: [ self makeStructsSanityChecklist ].

    '"Automatically generated, do not edit!"' displayNl.
!

emptyWaiting
    [ | n | 
	n := waiting size.
	waiting copy keysAndValuesDo: [ :k :v | 
	    (emitted includes: k) 
		ifTrue: [ waiting removeKey: k ]
		ifFalse: [
		    ('''w ', v name , ''' printNl!') displayNl.
		    self emitStruct: v. 
		    (k = 'GtkWidget') & (waiting includesKey: 'GtkWidget') 
			ifTrue: [ self error: 'GtkWidget still waiting???' ].
		].
	].
	waiting size < n.
    ] whileTrue.
    waiting size > 0 ifTrue: [ 
	waiting keysAndValuesDo: [ :k :v | 
	    v name printNl.
	    ('(', (v deps asOrderedCollection join: ', '), ')') printNl.
	].
	self error: 'waiting is not empty'.
    ].
    '"Remaining classes: Definition is probably private - parent classes may not be correct."' displayNl.
    (classNames reject: [ :each | emitted includes: each ]) 
	 do: [ :each | (StructDef new) name: each; parent: 'CStruct'; emit ].
!

sanityCheck
    | rdr |
    rdr := structsSanity reject: [ :each | emitted includes: each ].
    rdr isEmpty ifTrue: [ ^self ].
    '? ? ERROR: The following structs have not been generated:' displayNl.
    rdr do: [ :each | each displayNl ].
!

doEnd
    waiting notEmpty ifTrue: [ self emptyWaiting ].
    self sanityCheck.
    "classNames copy do: [ :each | 
	('''r ', each, ''' printNl!') displayNl.
	self emitSyn: each parent: 'CObject' 
    ]."
!

!

(StructsParser new)
    initialize;
    debugging: 1;
    parseArgv.
'''Structs finished'' printNl!' displayNl.
!

