
CharacterArray methodsFor: 'testing'!

isGName
    ^(#('g' 'atk' 'pango') anySatisfy: [ :each | self startsWith: each ])
!
!

Object subclass: #IncludesScanner 
       instanceVariableNames: 'paths ordered processed'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'make-postbootstrap'
!

IncludesScanner methodsFor: 'making'!

getEnv: aName allowFail: aAllowFail
    | r |
    r := Smalltalk getenv: aName.
    (r notNil | aAllowFail) 
	ifTrue: [ ^r ].
    self error: 'env var ', aName printString, ' is not set'.
!

getEnv: aName
    ^self getEnv: aName allowFail: false.
!

execute: aCommand
    ^(FileStream popen: aCommand dir: #read) contents.
!

initialize
    ordered := OrderedCollection new.
    paths := OrderedCollection new.
    processed := Set new. "Same as order, but a set for faster lookup"
!

processArgv
    1 to: Smalltalk getArgc do: [ :i | | arg |
	arg := Smalltalk getArgv: i.
	"gst parses -L params even when -a specified"
	(arg startsWith: 'L') 
	    ifTrue: [ self processLib: (arg copyFrom: 2) ]
	    ifFalse: [ 
		(arg startsWith: 'P')
		    ifTrue: [ self processPath: (arg copyFrom: 2) ]
		    ifFalse: [ self processFile: arg ].
	    ].
    ].
    self printOrdered.
!

processPath: aPath
    (paths includes: aPath) 
	ifFalse: [ paths add: aPath ].
!

processLib: aLib
    | cflags |
    "('""Adding paths from library: ', aLib, '""') displayNl."
    cflags := 
	(self execute: ((self getEnv: 'PKG_CONFIG'), ' --cflags ', aLib))
	subStrings.
    cflags do: [ :each | 
	(each startsWith: '-I') 
	    ifTrue: [ | path | self processPath: (each copyFrom: 3) ].
    ].
!

processFile: aFileName
    | incs file |
    (processed includes: aFileName) ifTrue: [ ^self ].
    processed add: aFileName.
    file := self findFile: aFileName.
    incs := self scanForIncludes: file.
    incs do: [ :each | each isGName ifTrue: [ self processFile: each ] ].
    ordered add: file fullName.
!

findFile: aFile
    paths isEmpty 
	ifTrue: [ self error: 'specify at least one library before the first file' ].
    paths do: [ :each | | f |
	f := File name: (each, '/', aFile).
	f isReadable ifTrue: [ ^f ].
    ].
    paths do: [ :each | ('looked in ', each) displayNl ].
    self error: 'Can''t find: ', aFile printString.
!

scanForIncludes: aFile
    | fs r |
    fs := aFile readStream.
    r := Set new.
    [ fs atEnd ] 
	whileFalse: [ | line |
            line := fs nextLine trimSeparators.
	    (line startsWith: '#include') 
		ifTrue: [
		    line := (line copyFrom: 9) trimSeparators.
		    (line startsWith: '<') 
			ifTrue: [ r add: (line copyFrom: 2 to: (line indexOf: $>) - 1) ].
		].
	].
    ^r
!

printOrdered
    ordered do: [ :each | each displayNl ].
!
!

IncludesScanner new initialize processArgv
!
